/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.sqlmap.engine.transaction;

import com.ibatis.common.util.Throttle;
import com.ibatis.sqlmap.engine.scope.SessionScope;
import com.ibatis.sqlmap.engine.transaction.Transaction;
import com.ibatis.sqlmap.engine.transaction.TransactionConfig;
import com.ibatis.sqlmap.engine.transaction.TransactionException;
import com.ibatis.sqlmap.engine.transaction.TransactionState;
import java.sql.SQLException;
import javax.sql.DataSource;

public class TransactionManager {
    private TransactionConfig transactionConfig;
    private Throttle txThrottle;

    public TransactionManager(TransactionConfig transactionConfig) {
        this.transactionConfig = transactionConfig;
        this.txThrottle = new Throttle(transactionConfig.getMaximumConcurrentTransactions());
    }

    public void begin(SessionScope session) throws SQLException, TransactionException {
        Transaction trans = session.getTransaction();
        TransactionState state = session.getTransactionState();
        if (state == TransactionState.STATE_STARTED) {
            throw new TransactionException("TransactionManager could not start a new transaction.  A transaction is already started.");
        }
        this.txThrottle.increment();
        try {
            trans = this.transactionConfig.newTransaction();
            session.setCommitRequired(false);
        }
        catch (SQLException e) {
            this.txThrottle.decrement();
            throw e;
        }
        catch (TransactionException e) {
            this.txThrottle.decrement();
            throw e;
        }
        session.setTransaction(trans);
        session.setTransactionState(TransactionState.STATE_STARTED);
    }

    public void commit(SessionScope session) throws SQLException, TransactionException {
        Transaction trans = session.getTransaction();
        TransactionState state = session.getTransactionState();
        if (state != TransactionState.STATE_STARTED) {
            throw new TransactionException("TransactionManager could not commit.  No transaction is started.");
        }
        if (session.isCommitRequired()) {
            trans.commit();
            session.setCommitRequired(false);
        }
        session.setTransactionState(TransactionState.STATE_COMMITTED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void end(SessionScope session) throws SQLException, TransactionException {
        Transaction trans = session.getTransaction();
        TransactionState state = session.getTransactionState();
        try {
            if (trans != null) {
                if (state != TransactionState.STATE_COMMITTED && session.isCommitRequired()) {
                    trans.rollback();
                    session.setCommitRequired(false);
                }
                trans.close();
            }
        }
        finally {
            if (state != TransactionState.STATE_ENDED) {
                this.txThrottle.decrement();
            }
            session.setTransaction(null);
            session.setTransactionState(TransactionState.STATE_ENDED);
        }
    }

    public DataSource getDataSource() {
        return this.transactionConfig.getDataSource();
    }
}

