/*
 * Decompiled with CFR 0.152.
 */
package xjavadoc.filesystem;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Arrays;
import xjavadoc.SourceSet;
import xjavadoc.Util;
import xjavadoc.filesystem.AbstractFile;
import xjavadoc.filesystem.XJavadocFile;

public final class FileSourceSet
implements SourceSet {
    private File _dir;
    private ArrayList _files;
    private int hash = Integer.MIN_VALUE;

    public FileSourceSet(File dir, String[] files) {
        if (dir == null) {
            throw new IllegalArgumentException("dir can't be null");
        }
        if (!dir.isDirectory()) {
            throw new IllegalArgumentException(dir.getAbsolutePath() + " must be a directory");
        }
        this._dir = dir;
        this._files = new ArrayList();
        if (files != null) {
            this._files.addAll(Arrays.asList(files));
        }
    }

    public FileSourceSet(File fileOrDir) {
        if (!fileOrDir.isDirectory() && !fileOrDir.exists()) {
            throw new IllegalArgumentException(fileOrDir.getAbsolutePath() + " must exist");
        }
        this._files = new ArrayList();
        if (fileOrDir.isDirectory()) {
            this._dir = fileOrDir;
            this._files.addAll(Arrays.asList(Util.getJavaFiles(fileOrDir)));
        } else {
            this._dir = fileOrDir.getParentFile();
            this._files.add(fileOrDir.getName());
        }
    }

    public AbstractFile[] getFiles() {
        throw new UnsupportedOperationException("Not yet implemented.");
    }

    public AbstractFile getSourceFile(String qualifiedName) {
        File sourceFile = new File(this._dir, this.getRelativeFileName(qualifiedName));
        if (!sourceFile.exists()) {
            return null;
        }
        return new XJavadocFile(sourceFile);
    }

    public String getQualifiedName(int i) {
        return this.getQualifiedName((String)this._files.get(i));
    }

    public int getSize() {
        return this._files.size();
    }

    public boolean containsAbsolute(String filename) {
        return filename.startsWith(this.getDir().getPath()) && this._files.contains(filename.substring(this.getDir().getPath().length() + 1));
    }

    public boolean containsRelative(String filename) {
        return this._files.contains(filename);
    }

    public boolean equals(Object o) {
        if (o instanceof FileSourceSet) {
            FileSourceSet other = (FileSourceSet)o;
            return this._dir.equals(other._dir) && this._files.equals(other._files);
        }
        return false;
    }

    public int hashCode() {
        if (this.hash == Integer.MIN_VALUE) {
            this.hash = this._dir.hashCode();
            if (this._files != null) {
                int i = 0;
                while (i < this._files.size()) {
                    this.hash += this._files.get(i).hashCode();
                    ++i;
                }
            }
        }
        return this.hash;
    }

    private File getDir() {
        return this._dir;
    }

    private String getQualifiedName(String relativeFileName) {
        String result = relativeFileName.replace('/', '.').replace('\\', '.');
        result = result.substring(0, result.length() - 5);
        return result;
    }

    private String getRelativeFileName(String qualifiedName) {
        return qualifiedName.replace('.', File.separatorChar) + ".java";
    }

    class DirectoryFilter
    implements FileFilter {
        DirectoryFilter() {
        }

        public boolean accept(File file) {
            return file.isDirectory();
        }
    }

    class JavaSourceFilter
    implements FileFilter {
        private static final String suffix = ".java";

        JavaSourceFilter() {
        }

        public boolean accept(File file) {
            return file.getName().endsWith(suffix);
        }
    }
}

