/*
 * Decompiled with CFR 0.152.
 */
package org.easymock;

import org.easymock.ParameterMatcher;

public abstract class AbstractMatcher
implements ParameterMatcher {
    protected boolean parameterMatches(Object expected, Object actual) {
        return expected.equals(actual);
    }

    protected String parameterToString(Object parameter) {
        if (parameter instanceof String) {
            return "\"" + parameter + "\"";
        }
        return "" + parameter;
    }

    public boolean matches(Object[] expected, Object[] actual) {
        if (expected == actual) {
            return true;
        }
        if (expected == null || actual == null) {
            return false;
        }
        if (expected.length != actual.length) {
            throw new RuntimeException("Bug in EasyMock.");
        }
        int i = 0;
        while (i < expected.length) {
            Object expectedObject = expected[i];
            Object actualObject = actual[i];
            if (expectedObject == null ? actualObject != null : !this.parameterMatches(expectedObject, actualObject)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public String toString(Object[] parameters) {
        if (parameters == null) {
            return "";
        }
        String result = "";
        int i = 0;
        while (i < parameters.length) {
            if (i > 0) {
                result = result + ", ";
            }
            result = result + this.parameterToString(parameters[i]);
            ++i;
        }
        return result;
    }
}

