/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.common.flatfile;

import com.ibatis.common.flatfile.FlatFileIn;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class DelimitedFlatFileIn
implements FlatFileIn {
    private static final int UNKNOWN_COLUM_COUNT = -1;
    private LineNumberReader reader = null;
    private ArrayList values = new ArrayList();
    private String delimiter = " ";
    private int colCount = -1;

    public DelimitedFlatFileIn(String string, String string2) throws IOException {
        this.delimiter = string2;
        this.reader = new LineNumberReader(new FileReader(string));
    }

    public boolean nextRecord() throws IOException {
        this.values.clear();
        String string = this.reader.readLine();
        if (string == null) {
            return false;
        }
        String string2 = null;
        String string3 = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string, this.delimiter, true);
        while (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
            if (string3 == null) {
                if (this.delimiter.equals(string2)) {
                    this.values.add("");
                } else {
                    this.values.add(string2);
                }
            } else if (this.delimiter.equals(string2) && this.delimiter.equals(string3)) {
                this.values.add("");
            } else if (!this.delimiter.equals(string2)) {
                this.values.add(string2);
            }
            string3 = string2;
        }
        if (this.colCount == -1) {
            this.colCount = this.values.size();
        } else if (this.colCount != this.values.size()) {
            throw new IOException("Inconsistent number of columns in row.");
        }
        return true;
    }

    public int getColumnCount() throws IOException {
        return this.colCount;
    }

    public String getValueAt(int n) throws IOException {
        return (String)this.values.get(n);
    }

    public void close() throws IOException {
        this.reader.close();
    }
}

