/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.common.util;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class PagedList
extends ArrayList {
    private int pageSize = 10;
    private int index = 1;

    public PagedList() {
    }

    public PagedList(int n) {
        this.pageSize = n;
    }

    public PagedList(int n, int n2) {
        super(n);
        this.pageSize = n2;
    }

    public PagedList(Collection collection, int n) {
        super(collection);
        this.pageSize = n;
    }

    public Iterator getPageIterator() {
        if (this.index * this.pageSize > this.size()) {
            return ((AbstractList)this).subList((this.index - 1) * this.pageSize, this.size()).iterator();
        }
        return ((AbstractList)this).subList((this.index - 1) * this.pageSize, (this.index - 1) * this.pageSize + this.pageSize).iterator();
    }

    public List getPageList() {
        if (this.index * this.pageSize > this.size()) {
            return ((AbstractList)this).subList((this.index - 1) * this.pageSize, this.size());
        }
        return ((AbstractList)this).subList((this.index - 1) * this.pageSize, (this.index - 1) * this.pageSize + this.pageSize);
    }

    public void nextPage() {
        ++this.index;
        if ((this.index - 1) * this.pageSize >= this.size()) {
            this.index = 1;
        }
    }

    public void previousPage() {
        --this.index;
        if (this.index < 1) {
            this.index = this.size() / this.pageSize;
            if (this.size() % this.pageSize != 0) {
                ++this.index;
            }
        }
    }

    public boolean isLastPage() {
        return this.index * this.pageSize >= this.size();
    }

    public boolean isFirstPage() {
        return this.index <= 1;
    }

    public boolean isMiddlePage() {
        return !this.isFirstPage() && !this.isLastPage();
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public boolean hasNextPage() {
        return !this.isLastPage();
    }

    public boolean hasPrevPage() {
        return !this.isFirstPage();
    }

    public void gotoPage(int n) {
        if (n < 0 || this.size() - n * this.pageSize < 0) {
            throw new ArrayIndexOutOfBoundsException("Attempt to access a page of PagedList that did not exist.");
        }
    }
}

