/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.common.util;

import com.ibatis.common.exception.NestedRuntimeException;
import java.util.HashMap;
import java.util.Map;

public class Throttle {
    private Map throttleMap = new HashMap();
    private int count;
    private int limit;
    private long maxWait;

    public Throttle(int n) {
        this.limit = n;
        this.maxWait = 0L;
    }

    public Throttle(int n, long l) {
        this.limit = n;
        this.maxWait = l;
    }

    private Throttle getThrottle(Object object) {
        Map map = this.throttleMap;
        synchronized (map) {
            Throttle throttle = (Throttle)this.throttleMap.get(object);
            if (throttle == null) {
                throttle = new Throttle(this.limit, this.maxWait);
                this.throttleMap.put(object, throttle);
            }
            Throttle throttle2 = throttle;
            return throttle2;
        }
    }

    public void increment(Object object) {
        Throttle throttle;
        Throttle throttle2 = throttle = this.getThrottle(object);
        synchronized (throttle2) {
            if (throttle.count >= throttle.limit) {
                if (this.maxWait > 0L) {
                    long l = System.currentTimeMillis();
                    try {
                        throttle.wait(this.maxWait);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    l = System.currentTimeMillis() - l;
                    if (l > this.maxWait) {
                        throw new NestedRuntimeException("Throttle waited too long (" + l + ") for object '" + object + "'.");
                    }
                } else {
                    try {
                        throttle.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            ++throttle.count;
        }
    }

    public void decrement(Object object) {
        Throttle throttle;
        Throttle throttle2 = throttle = this.getThrottle(object);
        synchronized (throttle2) {
            --throttle.count;
            throttle.notify();
        }
    }
}

