/*
 * Decompiled with CFR 0.152.
 */
package jp.co.scs.mbench;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import jp.co.scs.mbench.BenchmarkManager;
import jp.co.scs.mbench.MessageResources;

public class BenchmarkMain {
    private static BenchmarkManager manager = null;
    public static final String THREAD_NUMBER = "threadNumber";
    public static final String REPEAT_NUMBER = "repeatNumber";
    public static final String TX_NUMBER = "transactionNumber";
    public static final String END_TIME = "benchmarkEndTime";
    public static final String MULTI_CLIENT = "multi-client";
    public static final Set optionSet = new HashSet();
    public static final Map optionTable = new HashMap();

    static {
        optionSet.add(THREAD_NUMBER);
        optionSet.add(REPEAT_NUMBER);
        optionSet.add(TX_NUMBER);
        optionSet.add(END_TIME);
        optionSet.add(MULTI_CLIENT);
        optionTable.put("r", REPEAT_NUMBER);
        optionTable.put("t", THREAD_NUMBER);
        optionTable.put("T", TX_NUMBER);
        optionTable.put("e", END_TIME);
    }

    public static BenchmarkManager getManager() {
        return manager;
    }

    public static void setManager(BenchmarkManager manager) {
        BenchmarkMain.manager = manager;
    }

    public static void main(String[] args) throws Exception {
        String benchmarkName = null;
        HashMap optionMap = null;
        try {
            if (args != null && args.length > 0) {
                int i = 0;
                while (i < args.length) {
                    if (args[i].startsWith("-")) {
                        if (optionMap == null) {
                            optionMap = new HashMap();
                        }
                        BenchmarkMain.editOptionMap(args[i], optionMap);
                    } else {
                        benchmarkName = args[i];
                    }
                    ++i;
                }
                if (manager == null) {
                    manager = new BenchmarkManager(benchmarkName);
                }
                if (benchmarkName != null) {
                    manager.setOptionMap(optionMap);
                    manager.start();
                } else {
                    BenchmarkMain.printUsage();
                }
            } else {
                BenchmarkMain.printUsage();
            }
        }
        catch (IllegalArgumentException ex) {
            BenchmarkMain.printUsage();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void editOptionMap(String option, Map optionMap) throws IllegalArgumentException {
        String optionName = null;
        String optionValue = null;
        int equalIndex = option.indexOf(61);
        if (option.startsWith("--")) {
            if (equalIndex >= 0) {
                optionName = option.substring(2, equalIndex);
                optionValue = option.substring(equalIndex + 1);
                equalIndex = optionValue.indexOf("=");
            } else {
                optionName = option.substring(2);
            }
            if (!optionSet.contains(optionName)) throw new IllegalArgumentException();
            if (equalIndex > 0) {
                HashMap<String, String> optionValueMap = new HashMap<String, String>();
                optionValueMap.put(optionValue.substring(0, equalIndex), optionValue.substring(equalIndex));
                optionMap.put(optionName, optionValueMap);
                return;
            } else {
                optionMap.put(optionName, optionValue);
            }
            return;
        } else {
            if (!optionTable.containsKey(option.substring(1, 2))) throw new IllegalArgumentException();
            optionName = (String)optionTable.get(option.substring(1, 2));
            optionValue = option.substring(2);
            equalIndex = optionValue.indexOf("=");
            if (equalIndex > 0) {
                HashMap<String, String> optionValueMap = new HashMap<String, String>();
                optionValueMap.put(optionValue.substring(0, equalIndex), optionValue.substring(equalIndex));
                optionMap.put(optionName, optionValueMap);
                return;
            } else {
                optionMap.put(optionName, optionValue);
            }
        }
    }

    public static String getUsage() {
        return MessageResources.getMessage("BenchmarkMain.usage");
    }

    private static void printUsage() {
        System.out.print(BenchmarkMain.getUsage());
    }
}

