/*
 * Decompiled with CFR 0.152.
 */
package jp.co.scs.mbench;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedList;
import jp.co.scs.mbench.BenchmarkTerminateException;
import jp.co.scs.mbench.LogHolder;

public class LogWriter
extends Thread {
    public static final int DEBUG = 0;
    public static final int INFO = 1;
    public static final int ERROR = 2;
    protected static String debug_label = "[DEBUG]";
    protected static String info_label = "[INFO]";
    protected static String error_label = "[ERROR]";
    private int logLevel = 1;
    private String logName = null;
    private BufferedWriter writer = null;
    private boolean isInitialized = false;
    private boolean isRunning = false;
    private LinkedList logQueue = new LinkedList();
    private int remove = 0;
    private int add = 1;

    public LogWriter(String logName) {
        this.logName = logName;
    }

    public String getLogName() {
        return this.logName;
    }

    public void setLogName(String logName) {
        this.logName = logName;
    }

    public int getLogLevel() {
        return this.logLevel;
    }

    public void setLogLevel(int logLevel) {
        this.logLevel = logLevel;
    }

    public boolean isInitialized() {
        return this.isInitialized;
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public int getLogQueueSize() {
        return this.logQueue.size();
    }

    public void init() throws BenchmarkTerminateException {
        try {
            this.writer = new BufferedWriter(new FileWriter(this.logName));
            this.start();
            this.isInitialized = true;
        }
        catch (IOException ex) {
            ex.printStackTrace();
            throw new BenchmarkTerminateException(ex);
        }
    }

    public void write(int level, String desc) {
        if (level < this.logLevel) {
            return;
        }
        Date registTime = Calendar.getInstance().getTime();
        this.manipulateQueue(this.add, new LogHolder(registTime, level, desc));
    }

    public void run() {
        try {
            this.isRunning = true;
            while (this.isRunning || this.logQueue.size() > 0) {
                Object obj = this.manipulateQueue(this.remove, null);
                if (obj != null) {
                    LogHolder holder = (LogHolder)obj;
                    String pattern = "HH:mm:ss:SS";
                    SimpleDateFormat dateFormat = new SimpleDateFormat(pattern);
                    String timeHeader = "[" + dateFormat.format(holder.getDate()) + "]";
                    if (holder.getLogLevel() == 1) {
                        System.out.println(String.valueOf(timeHeader) + info_label + holder.getLogDesc());
                        this.writer.write(String.valueOf(timeHeader) + info_label + holder.getLogDesc() + "\n");
                        continue;
                    }
                    if (holder.getLogLevel() == 2) {
                        System.err.println(String.valueOf(timeHeader) + error_label + holder.getLogDesc());
                        this.writer.write(String.valueOf(timeHeader) + error_label + holder.getLogDesc() + "\n");
                        continue;
                    }
                    if (holder.getLogLevel() != 0) continue;
                    System.out.println(String.valueOf(timeHeader) + debug_label + holder.getLogDesc());
                    this.writer.write(String.valueOf(timeHeader) + debug_label + holder.getLogDesc() + "\n");
                    continue;
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        catch (IOException ex) {
            this.isRunning = false;
            this.isInitialized = false;
            ex.printStackTrace();
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void clean() {
        try {
            try {
                while (true) {
                    if (!this.isInitialized || this.logQueue.size() <= 0) {
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        break;
                    }
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                this.isRunning = false;
                this.writer.close();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        catch (Throwable throwable) {
            Object var2_5 = null;
            this.isInitialized = false;
            throw throwable;
        }
        {
            Object var2_6 = null;
            this.isInitialized = false;
            return;
        }
    }

    private synchronized Object manipulateQueue(int command, Object obj) {
        if (command == this.add) {
            this.logQueue.addLast(obj);
            return null;
        }
        if (command == this.remove) {
            if (this.logQueue.size() > 0) {
                return this.logQueue.removeFirst();
            }
            return null;
        }
        return null;
    }
}

