/*                          
 * mBench: The Open Source Micro Benchmark Tool 
 *                                             
 * Distributable under GPL license. 
 * See terms of license at gnu.org.                 
 *
 * Copyright (C) 2005 Sumisho Computer Systems Corp.
 */
package jp.co.scs.mbench;

/**
 *      Finalizer interface.
 *      <br>
 *      setFinalizerName should be called first.
 * 
 *      @author Tetsuro Ikeda
 */
public interface Finalizer {
    /**
     *  Gets the finalizer name.
     * 
     *  @return finalizer name
     */
    String getFinalizerName();
    
    /**
     *  Sets the finalizer name.
     * 
     *  @param finalizerName finalizer name
     */
    void setFinalizerName(String finalizerName);
    
    /**
     *  Execute finalize operation.
     */
    void execute() throws BenchmarkTerminateException;
}
