/*                          
 * mBench: The Open Source Micro Benchmark Tool 
 *                                             
 * Distributable under GPL license. 
 * See terms of license at gnu.org.                 
 *
 * Copyright (C) 2005 Sumisho Computer Systems Corp.
 */
package jp.co.scs.mbench;

/**
 *      Initializer interface.<br>
 *      <br>
 *      setInitializerName should be called first.
 * 
 *      @author Tetsuro Ikeda
 */
public interface Initializer {
    /**
     *  Gets the initializer name.
     * 
     *  @return initializer name
     */
    String getInitializerName();
    
    /**
     *  Sets the initializer name.
     * 
     *  @param initializerName initializer name
     */
    void setInitializerName(String initializerName);
    
    /**
     *  Execute the initialize operation.
     */
    void execute() throws BenchmarkTerminateException;
}
