/*
 *      OSS Project
 *
 *      System Engineering Dept.
 *      System Engineering Group.
 *      Sumisho Computer Systems Corporation
 *
 *      Copyright (C) 2005 Sumisho Computer Systems Corporation,
 *      All Rights Reserved.
 */

package jp.co.scs.mbench.component;

import jp.co.scs.mbench.Benchmark;
import jp.co.scs.mbench.BenchmarkAbortException;
import jp.co.scs.mbench.BenchmarkTerminateException;
import jp.co.scs.mbench.ThreadTerminateException;

/**
 *      Sample Test Transaction for mBench biginners.
 * 
 *      @author Masato Koga
 */
public class SampleBenchmark implements Benchmark {
    /**
     *  Benchmark Name from XML (this attribute must be defined) 
     */
    private String benchmarkName = null;

    /** 
     *  Get the component name.
     * 
     *  @return Name of component
     */
    public String getBenchmarkName() {
        return this.benchmarkName;
    }

    /**
     *  Set the component name.
     * 
     *  @param benchmarkName Name of component
     */
    public void setBenchmarkName(String benchmarkName) {
        this.benchmarkName = benchmarkName;
    }
    
    /**
     *  Get labels mesured by benchmark component.
     *  
     *  If you define labels for your original test,
     *  you have to define attribute "optionLables"
     *  String array. 
     * 
     *  @return Label of items mesured by benchmark component
     */
    public String[] getOptionLabels() {
        return null;
    }

    /**
     *  Set labels mesured by benchmark component.
     *  
     *  If you define labels for your original test,
     *  you have to define attribute "optionLables"
     *  String array.
     */
    public void setOptionLabels(String[] optionLabels) { }

    /**
     *  Initialize for each threads.
     *  
     *  For example, if you test a database transaction,
     *  you can define database connect process.
     */
    public void init() throws BenchmarkTerminateException { }

    /**
     *  Test transaction for each threads.
     *  
     *  You can implement your transaction that you want to test.
     */
    public String[] execute() throws ThreadTerminateException,
            BenchmarkTerminateException {
        try {
            Thread.sleep(Math.round(Math.random() * 1000));
        } catch (InterruptedException ex) {
            // ignore
        }
        return null;
    }

    /**
     *  Finalize for each threads.
     *  
     *  If you test a database transaction,
     *  you can define database disconnect process.
     */
    public void clean() throws BenchmarkAbortException { }

}
