/*                          
 * mBench: The Open Source Micro Benchmark Tool 
 *                                             
 * Distributable under GPL license. 
 * See terms of license at gnu.org.                 
 *
 * Copyright (C) 2005 Sumisho Computer Systems Corp.
 */
package jp.co.scs.mbench.component;

import java.sql.Connection;
import java.sql.Statement;
import javax.sql.DataSource;

import jp.co.scs.mbench.Initializer;
import jp.co.scs.mbench.jdbc.DataSourceManager;

/**
 *     Create table t1.
 * 
 *     @author Masato Koga
 */
public class T1Initializer implements Initializer {
    
    private String initializerName = null;

    public String getInitializerName() {
        return this.initializerName;
    }

    public void setInitializerName(String initializerName) {
        this.initializerName = initializerName;
    }

    /**
     *  Create table t1.<br>
     *  <br>
     *  Excute queries following:<br>
     *  drop table if exists t2;<br>
     *  create table t2 (c1 int primary key, c2 int);<br>
     */
    public void execute() {
        Connection con = null;
        Statement stmt = null;
        try {
            DataSource dataSource = DataSourceManager.getDataSource("mysql_con1");
            con = dataSource.getConnection();
            stmt = con.createStatement();
            
            String ddl1 = "drop table if exists t1";
            stmt.executeUpdate(ddl1);
            String ddl2 = "create table t1 (c1 int primary key , c2 int)";
            stmt.executeUpdate(ddl2);
        } catch (Exception ex) {
            ex.printStackTrace();
        } finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (con != null) {
                    con.close();
                }
            } catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

}
