/*                          
 * mBench: The Open Source Micro Benchmark Tool 
 *                                             
 * Distributable under GPL license. 
 * See terms of license at gnu.org.                 
 *
 * Copyright (C) 2005 Sumisho Computer Systems Corp.
 */
package test.jp.co.scs.mbench;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;


/**
 *      @author Toshio Sugahara
 */
public class FileUtil {

    private FileUtil() { }

    public static boolean existsFile(String filename) {
        File targetFile = new File(filename);
        return targetFile.exists();
    }

    public static boolean compareFiles(
            String originalFilename, String targetFilename)
            throws FileNotFoundException, IOException {
        BufferedReader originalFile = null;
        BufferedReader targetFile = null;
        try {
            originalFile = new BufferedReader(new InputStreamReader(
                new FileInputStream(originalFilename)));
            targetFile = new BufferedReader(new InputStreamReader(
                new FileInputStream(targetFilename)));
            while (originalFile.ready() && targetFile.ready()) {
                if (!originalFile.readLine().equals(targetFile.readLine())) {
                    return false;
                }
            }
            if (originalFile.ready() || targetFile.ready()) {
                return false;
            }
            return true;
        } finally {
            if (originalFile != null) {
                originalFile.close();
            }
            if (targetFile != null) {
                targetFile.close();
            }
        }
    }

    public static void deleteFile(String path) {
        File file = new File(path);
        if (file == null) {
            return;
        }
        File[] subFiles = file.listFiles();
        if (subFiles != null) {
            for (int i = 0; i < subFiles.length; i++) {
                if (subFiles[i].isDirectory()) {
                    deleteFile(subFiles[i].getPath());
                } else {
                    subFiles[i].delete();
                }
            }
        }
        file.delete();
    }

    public static void copyFiles(String srcPath, String destPath)
            throws Exception {
        File[] copyFiles = null;
        File copyFile = new File(srcPath).getAbsoluteFile();
        if (copyFile == null) {
            return;
        } else if (copyFile.isDirectory()) {
            copyFiles = copyFile.listFiles();
        } else {
            copyFiles = new File[1];
            copyFiles[0] = copyFile.getAbsoluteFile();
        }

        File destDir = new File(destPath).getAbsoluteFile();
        destDir.mkdir();
        String fileSeparator = System.getProperty("file.separator");
        for (int i = 0; i < copyFiles.length; i++) {
            FileReader reader = null;
            FileWriter writer = null;
            try {
                reader = new FileReader(copyFiles[i]);
                writer = new FileWriter(destDir + fileSeparator
                    + copyFiles[i].getName());
                int read = 0;
                while (true) {
                    read = reader.read();
                    if (read == -1) {
                        break;
                    }
                    writer.write(read);
                }
                writer.flush();
            } catch (FileNotFoundException ex) {
                // for some kind of JVM
            } finally {
                if (writer != null) {
                    writer.close();
                }
                if (reader != null) {
                    reader.close();
                }
            }
        }
    }
}
