/*                          
 * mBench: The Open Source Micro Benchmark Tool 
 *                                             
 * Distributable under GPL license. 
 * See terms of license at gnu.org.                 
 *
 * Copyright (C) 2005 Sumisho Computer Systems Corp.
 */
package test.jp.co.scs.mbench.stub;

import jp.co.scs.mbench.BenchmarkInfo;
import jp.co.scs.mbench.DataWriter;
import jp.co.scs.mbench.LogWriter;
import jp.co.scs.mbench.BenchmarkState;
import jp.co.scs.mbench.Synchronizer;

/**
 *      The stub for testing BenchmarkManager.
 *      This stub marks BENCHMARK_TERMINATED at execute method.
 * 
 *      @author Tetsuro Ikeda
 */
public class StubBenchmarkManagerContainer3 extends
        StubBenchmarkManagerContainer {

    private static int errorIndex = 0;
    
    private static int index = 0;
    
    public StubBenchmarkManagerContainer3(
            int containerID,
            BenchmarkInfo info,
            Synchronizer synchronizer,
            LogWriter logWriter,
            DataWriter dataWriter) {
        super(containerID, info, synchronizer, logWriter, dataWriter);
    }
    
    public static void setErrorIndex(int errorIndex) {
        StubBenchmarkManagerContainer3.errorIndex = errorIndex;
    }

    public void executeTarget() {
        this.currentState = BenchmarkState.RUNNING;
        if (++index >= errorIndex) {
            this.currentState = BenchmarkState.BENCHMARK_TERMINATED;
        }
    }
}
