/*                          
 * mBench: The Open Source Micro Benchmark Tool 
 *                                             
 * Distributable under GPL license. 
 * See terms of license at gnu.org.                 
 *
 * Copyright (C) 2005 Sumisho Computer Systems Corp.
 */
package test.jp.co.scs.mbench.stub;

import java.io.IOException;
import java.io.InputStream;
import java.net.ServerSocket;
import java.net.Socket;

/**
 *      The stub behave as secondary node.
 * 
 *      @author Tetsuro Ikeda
 */
public class StubBenchmarkManagerSecondaryNode2 extends
        StubBenchmarkManagerSecondaryNode {

    public StubBenchmarkManagerSecondaryNode2(int port) {
        super(port);
    }

    public void run() {
        try {
            ServerSocket server = new ServerSocket(this.port);
            server.setSoTimeout(50000);
            Socket socket = server.accept();
            socket.setSoTimeout(50000);
            byte[] buffer = new byte[20];
            InputStream is = socket.getInputStream();
            is.read(buffer);
            buffer = trimBlankByte(buffer);
            String message = new String(buffer);
            this.messageList.add(message);
            
        } catch (IOException ex) {
            this.messageList.add(ex.getMessage());
            ex.printStackTrace();
        }
    }
    
}
