/*
 * Decompiled with CFR 0.152.
 */
package jp.co.scs.mbench;

import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import jp.co.scs.mbench.BenchmarkAbortException;
import jp.co.scs.mbench.BenchmarkTerminateException;
import jp.co.scs.mbench.DocumentUtil;
import jp.co.scs.mbench.Initializer;
import jp.co.scs.mbench.InitializerInfo;
import org.xml.sax.SAXException;

public class InitializeManager {
    private String initializerName = null;
    private Initializer initializer = null;

    public InitializeManager(String initializerName) {
        this.initializerName = initializerName;
    }

    public String getInitializerName() {
        return this.initializerName;
    }

    public void setInitializerName(String initializerName) {
        this.initializerName = initializerName;
    }

    public Initializer getInitializer() {
        return this.initializer;
    }

    public void setInitializer(Initializer initializer) {
        this.initializer = initializer;
    }

    public void execute() throws BenchmarkTerminateException {
        try {
            InitializerInfo info = DocumentUtil.getInitializerInfo(this.initializerName);
            this.initializer = this.getInitializer(info);
            this.initializer.setInitializerName(info.getName());
            this.initializer.execute();
            System.out.println("initialize done ... " + this.initializerName);
        }
        catch (IOException ex) {
            ex.printStackTrace();
            throw new RuntimeException("error occur in InitializerManager#execute");
        }
        catch (ParserConfigurationException ex) {
            ex.printStackTrace();
            throw new RuntimeException("error occur in InitializerManager#execute");
        }
        catch (SAXException ex) {
            ex.printStackTrace();
            throw new RuntimeException("error occur in InitializerManager#execute");
        }
    }

    public Initializer getInitializer(InitializerInfo info) {
        try {
            Class<?> classObject = Class.forName(info.getClassName());
            return (Initializer)classObject.newInstance();
        }
        catch (ClassNotFoundException ex) {
            throw new BenchmarkAbortException(ex);
        }
        catch (InstantiationException ex) {
            throw new BenchmarkAbortException(ex);
        }
        catch (IllegalAccessException ex) {
            throw new BenchmarkAbortException(ex);
        }
    }
}

