/*
 * Decompiled with CFR 0.152.
 */
package jp.co.scs.mbench.component;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import jp.co.scs.mbench.BenchmarkTerminateException;
import jp.co.scs.mbench.Finalizer;

public class ResponseStatisticFinalizer
implements Finalizer {
    private String finalizerName = null;

    public String getFinalizerName() {
        return this.finalizerName;
    }

    public void setFinalizerName(String finalizerName) {
        this.finalizerName = finalizerName;
    }

    public void execute() throws BenchmarkTerminateException {
        File file = new File(".");
        File[] files = file.listFiles();
        int i = 0;
        while (i < files.length) {
            String fileName = files[i].getName();
            if (fileName.startsWith("data_") && fileName.endsWith(".csv")) {
                this.calculate(files[i]);
            }
            ++i;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void calculate(File file) throws BenchmarkTerminateException {
        InputStreamReader ir = null;
        BufferedReader reader = null;
        BufferedWriter writer = null;
        int maxResponseTime = 0;
        int minResponseTime = 0;
        long sumResponseTime = 0L;
        try {
            block16: {
                try {
                    ir = new InputStreamReader(new FileInputStream(file));
                    reader = new BufferedReader(ir);
                    reader.readLine();
                    int lineCount = 0;
                    String lineStr = reader.readLine();
                    while (true) {
                        if (lineStr == null || lineStr.startsWith("M")) {
                            if (lineStr != null) break;
                            writer = new BufferedWriter(new FileWriter(file, true));
                            writer.write("Min Response Time :,,,," + minResponseTime + "\n");
                            writer.write("Max Response Time :,,,," + maxResponseTime + "\n");
                            writer.write("Avg Response Time :,,,," + (float)sumResponseTime / (float)lineCount + "\n");
                            System.out.println("Data file: \"" + file.getName() + "\" is calculated");
                            break block16;
                        }
                        int responseTime = this.readValue(lineStr, 4);
                        if (responseTime > maxResponseTime || ++lineCount == 1) {
                            maxResponseTime = responseTime;
                        }
                        if (responseTime < minResponseTime || lineCount == 1) {
                            minResponseTime = responseTime;
                        }
                        sumResponseTime += (long)responseTime;
                        int endTime = this.readValue(lineStr, 3);
                        lineStr = reader.readLine();
                    }
                    System.out.println("Data file: \"" + file.getName() + "\" has been already calculated");
                }
                catch (Exception ex) {
                    System.out.println("Data file: \"" + file.getName() + "\" has an irregular  format");
                }
            }
            Object var13_15 = null;
        }
        catch (Throwable throwable) {
            Object var13_14 = null;
            try {
                if (ir != null) {
                    ir.close();
                }
                if (reader != null) {
                    reader.close();
                }
                if (writer == null) throw throwable;
                writer.close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException iOException) {
            return;
        }
        if (ir != null) {
            ir.close();
        }
        if (reader != null) {
            reader.close();
        }
        if (writer == null) return;
        writer.close();
    }

    private int readValue(String lineStr, int number) {
        int fromIndex = 0;
        int i = 0;
        while (i < number) {
            fromIndex = lineStr.indexOf(44, fromIndex) + 1;
            ++i;
        }
        int endIndex = lineStr.indexOf(44, fromIndex);
        return Integer.parseInt(lineStr.substring(fromIndex, endIndex));
    }
}

