/*
 * Decompiled with CFR 0.152.
 */
package jp.co.scs.mbench.component.doublenode;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;
import jp.co.scs.mbench.Benchmark;
import jp.co.scs.mbench.BenchmarkTerminateException;
import jp.co.scs.mbench.jdbc.DataSourceManager;

public class Select01T2Benchmark
implements Benchmark {
    private static int conCount = 0;
    private String benchmarkName = null;
    private String[] optionLabels = new String[]{"status", "primary-key", "value", "retry"};
    private Connection con = null;
    private Statement stmt = null;

    public String getBenchmarkName() {
        return this.benchmarkName;
    }

    public void setBenchmarkName(String benchmarkName) {
        this.benchmarkName = benchmarkName;
    }

    public String[] getOptionLabels() {
        return this.optionLabels;
    }

    public void setOptionLabels(String[] optionLabels) {
        this.optionLabels = optionLabels;
    }

    public synchronized void init() throws BenchmarkTerminateException {
        try {
            DataSource dataSource = null;
            dataSource = conCount % 2 == 0 ? DataSourceManager.getDataSource("mysql_con1") : DataSourceManager.getDataSource("mysql_con2");
            ++conCount;
            this.con = dataSource.getConnection();
            this.stmt = this.con.createStatement();
        }
        catch (Exception ex) {
            throw new BenchmarkTerminateException(ex);
        }
    }

    public String[] execute() {
        int key = (int)Math.round(60000.0 * Math.random() + 0.5);
        return this.doExecute(key, 0);
    }

    public void clean() {
        try {
            if (this.stmt != null) {
                this.stmt.close();
            }
            if (this.con != null) {
                this.con.close();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private String[] doExecute(int key, int retry) {
        try {
            String q1 = "select * from t2 where c1 = " + key;
            this.con.setAutoCommit(false);
            this.con.setTransactionIsolation(2);
            ResultSet rs = this.stmt.executeQuery(q1);
            int value = 0;
            rs.next();
            value = rs.getInt("c1");
            String[] result = new String[16];
            int i = 0;
            while (i < 16) {
                result[i] = rs.getString(i + 3);
                ++i;
            }
            this.con.commit();
            return new String[]{"commit", String.valueOf(key), String.valueOf(value), String.valueOf(retry)};
        }
        catch (SQLException ex) {
            if (this.con != null) {
                try {
                    this.con.rollback();
                    if (key > 60000) {
                        key = 0;
                    }
                    return this.doExecute(++key, ++retry);
                }
                catch (SQLException ex2) {
                    ex2.printStackTrace();
                    throw new RuntimeException("system error");
                }
            }
            throw new RuntimeException("connection lost");
        }
    }
}

