/*
 * Decompiled with CFR 0.152.
 */
package jp.co.scs.mbench.component.quadruplenode;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;
import jp.co.scs.mbench.Benchmark;
import jp.co.scs.mbench.BenchmarkTerminateException;
import jp.co.scs.mbench.jdbc.DataSourceManager;

public class Update01T2Benchmark
implements Benchmark {
    private static int conCount = 0;
    private static final String longLetter = "qrstuvwxyzqrstuvwxyzqrstuvwxyzqrstuvwxyzqrstuvwxyzqrstuvwxyzqrstuvwxyzqrstuvwxyzqrstuvwxyzqrstuvwxyzqrstuvwxyzqrstuvwxyzqrstuvwxyzqrstuvwxyzqrstuvwxyzqrstuvwxyzqrstuvwxyzqrstuvwxyzqrstuvwxyzqrstuvwxyzqrstuvwxyzqrstuvwxyzqrstuvwxyzqrstuvwxyzqrstu";
    private static final String shortLetter = "qrstuvwxyzqrstuvwxyzqrstuvwxyzqrstuvwxyzqrstuvwxyzqrstuvwxyzqrstuvwxyzqrstuvwxyzqrstuvwxyzqrstuvwxyzqrstuvwxyzqrstuvwxyzqrstuvwxyzqrstuvwxyzqrstuvwxyzqrst";
    private int threadIterationCount = 0;
    private String benchmarkName = null;
    private String[] optionLabels = new String[]{"status", "primary-key", "retry"};
    private Connection con = null;
    private Statement stmt = null;

    public String getBenchmarkName() {
        return this.benchmarkName;
    }

    public void setBenchmarkName(String benchmarkName) {
        this.benchmarkName = benchmarkName;
    }

    public String[] getOptionLabels() {
        return this.optionLabels;
    }

    public void setOptionLabels(String[] optionLabels) {
        this.optionLabels = optionLabels;
    }

    public synchronized void init() throws BenchmarkTerminateException {
        try {
            DataSource dataSource = null;
            dataSource = conCount % 4 == 0 ? DataSourceManager.getDataSource("mysql_con1") : (conCount % 4 == 1 ? DataSourceManager.getDataSource("mysql_con2") : (conCount % 4 == 2 ? DataSourceManager.getDataSource("mysql_con3") : DataSourceManager.getDataSource("mysql_con4")));
            ++conCount;
            this.con = dataSource.getConnection();
            this.stmt = this.con.createStatement();
        }
        catch (Exception ex) {
            throw new BenchmarkTerminateException(ex);
        }
    }

    public String[] execute() {
        ++this.threadIterationCount;
        int key = (int)Math.round(100.0 * Math.random() + 0.5);
        return this.doExecute(key, 0);
    }

    public void clean() {
        try {
            if (this.stmt != null) {
                this.stmt.close();
            }
            if (this.con != null) {
                this.con.close();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private String[] doExecute(int key, int retry) {
        try {
            this.con.setAutoCommit(false);
            this.con.setTransactionIsolation(2);
            StringBuffer q1 = new StringBuffer(4050);
            q1.append("update t2 set c2 = c2 + 1");
            int i = 0;
            while (i < 15) {
                q1.append(", c" + (i + 3) + " = \"" + key + this.threadIterationCount + longLetter + "\"");
                ++i;
            }
            q1.append(", c18 = \"" + key + this.threadIterationCount + shortLetter + "\" where c1 = " + key);
            this.stmt.executeUpdate(q1.toString());
            this.con.commit();
            return new String[]{"commit", String.valueOf(key), String.valueOf(retry)};
        }
        catch (SQLException ex) {
            ex.printStackTrace();
            if (this.con != null) {
                try {
                    this.con.rollback();
                    return this.doExecute(key, ++retry);
                }
                catch (SQLException ex2) {
                    ex2.printStackTrace();
                    throw new RuntimeException("system error");
                }
            }
            throw new RuntimeException("connection lost");
        }
    }
}

