/*
 * Decompiled with CFR 0.152.
 */
package jp.co.scs.mbench.component.singlenode;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;
import jp.co.scs.mbench.Benchmark;
import jp.co.scs.mbench.BenchmarkTerminateException;
import jp.co.scs.mbench.jdbc.DataSourceManager;

public class Select03T1Benchmark
implements Benchmark {
    private static int conCount = 0;
    private String benchmarkName = null;
    private String[] optionLabels = new String[]{"status", "cases", "retry"};
    private Connection con = null;
    private Statement stmt = null;

    public String getBenchmarkName() {
        return this.benchmarkName;
    }

    public void setBenchmarkName(String benchmarkName) {
        this.benchmarkName = benchmarkName;
    }

    public String[] getOptionLabels() {
        return this.optionLabels;
    }

    public void setOptionLabels(String[] optionLabels) {
        this.optionLabels = optionLabels;
    }

    public synchronized void init() throws BenchmarkTerminateException {
        try {
            DataSource dataSource = null;
            dataSource = DataSourceManager.getDataSource("mysql_con1");
            ++conCount;
            this.con = dataSource.getConnection();
            this.stmt = this.con.createStatement();
            this.stmt.setQueryTimeout(1);
        }
        catch (Exception ex) {
            throw new BenchmarkTerminateException(ex);
        }
    }

    public String[] execute() {
        return this.doExecute(0);
    }

    public void clean() {
        try {
            if (this.stmt != null) {
                this.stmt.close();
            }
            if (this.con != null) {
                this.con.close();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private String[] doExecute(int retry) {
        try {
            String q1 = "select * from t1 where c2 = 1";
            this.con.setAutoCommit(false);
            this.con.setTransactionIsolation(2);
            ResultSet rs = this.stmt.executeQuery(q1);
            int cases = 0;
            while (rs.next()) {
                ++cases;
            }
            this.con.commit();
            return new String[]{"commit", String.valueOf(cases), String.valueOf(retry)};
        }
        catch (SQLException ex) {
            if (this.con != null) {
                try {
                    this.con.rollback();
                    System.out.println("Timeout");
                    return new String[]{"rollback", "error", ex.getMessage()};
                }
                catch (SQLException ex2) {
                    ex2.printStackTrace();
                    throw new RuntimeException("system error");
                }
            }
            throw new RuntimeException("connection lost");
        }
    }
}

