/*                          
 * mBench: The Open Source Micro Benchmark Tool 
 *                                             
 * Distributable under GPL license. 
 * See terms of license at gnu.org.                 
 *
 * Copyright (C) 2005 Sumisho Computer Systems Corp.
 */
package jp.co.scs.mbench;

/**
 *      Bean for the benchmark component
 * 
 *      @author Tetsuro Ikeda
 *      @author Masato Koga
 */
public class BenchmarkInfo {
    /**
     *  benchmark component name
     */
    private String name = null;
    
    /**
     *  FQCN of the benchmark component
     */
    private String className = null;
    
    /**
     *  repeat number
     */
    private int repeatNumber = 10;
    
    /**
     *  threads number
     */
    private int threadNumber = 2;
    
    /**
     *  transaction number of all benchmark
     */
    private int transactionNumber = 0;
    
    /**
     *  benchmark start time
     */
    private long benchmarkStartTime = 0;
    
    /**
     *  benchmark end time (The measure is scond)
     */
    private long benchmarkEndTime = 0;
    
    /**
     *  gets the benchmark component name
     * 
     *  @return component name
     */
    public String getName() {
        return this.name;
    }
    
    /**
     *  sets the bechmark component name
     * 
     *  @param benchmarkName component name
     */
    public void setName(String benchmarkName) {
        this.name = benchmarkName;
    }
    
    /**
     *  gets the FQCN of the benchmark component.
     * 
     *  @return FQCN of the benchmark component
     */
    public String getClassName() {
        return this.className;
    }
    
    /**
     *  sets the FQCN of the benchmark component.
     * 
     *  @param className FQCN of the benchmark component.
     */
    public void setClassName(String className) {
        this.className = className;
    }
    
    /**
     *  gets the repeat number for each container.
     *  default is 10.
     * 
     *  @return repeat number
     */
    public int getRepeatNumber() {
        return this.repeatNumber;
    }
    
    /**
     *  sets the repeat number for each container.
     * 
     *  @param repeatNumber repeat number
     */
    public void setRepeatNumber(int repeatNumber) {
        this.repeatNumber = repeatNumber;
    }
    
    /**
     *  Gets the threads number.
     *  Each thread holds one container.
     *  Default is 2.
     * 
     *  @return threads number
     */
    public int getThreadNumber() {
        return this.threadNumber;
    }
    
    /**
     *  Sets the threads number.
     *  Each thread holds one container.
     * 
     *  @param threadNumber threads number
     */
    public void setThreadNumber(int threadNumber) {
        this.threadNumber = threadNumber;
    }
    
    /**
     *  Gets the transaction number of all benchmark
     *  
     *  @return transaction number of all benchmark
     */
    public int getTransactionNumber() {
        return this.transactionNumber;
    }
    
    /**
     *  Sets the transaction number of all benchmark
     * 
     *  @param transactionNumber transaction number of all benchmark
     */
    public void setTransactionNumber(int transactionNumber) {
        this.transactionNumber = transactionNumber;
    }
    
    /**
     *  Gets the benchmark start time.
     * 
     *  @return benchmark start time
     */
    public long getBenchmarkStartTime() {
        return this.benchmarkStartTime;
    }
    
    /**
     *  Sets the benchmark start time.
     * 
     *  @param benchmarkStartTime benchmark start time
     */
    public void setBenchmarkStartTime(long benchmarkStartTime) {
        this.benchmarkStartTime = benchmarkStartTime;
    }
    
    /**
     *  Gets the benchmark end time.
     *  
     *  @return benchmark end time
     */
    public long getBenchmarkEndTime() {
        return this.benchmarkEndTime;
    }
    
    /**
     *  Sets the benchmark end time.
     * 
     *  @param benchmarkEndTime benchmark end time
     */
    public void setBenchmarkEndTime(long benchmarkEndTime) {
        this.benchmarkEndTime = benchmarkEndTime;
    }
}
