/*                          
 * mBench: The Open Source Micro Benchmark Tool 
 *                                             
 * Distributable under GPL license. 
 * See terms of license at gnu.org.                 
 *
 * Copyright (C) 2005 Sumisho Computer Systems Corp.
 */
package jp.co.scs.mbench;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;

/**
 *      Manage the property files.
 *
 *      @author Masato Koga
 */
public class MessageResources {
    /**
     *  Name of property file
     */
    private static final String RESOURCE_NAME = "mbench";

    /**
     *  Mapping of the locale key and the property file
     */
    private static Map resourceMap = new HashMap();
    
    private MessageResources() { }
    
    /**
     *  Get the message from the key.
     *
     *  @param key the message key
     *  @return message
     */
    public static String getMessage(String key) {
        return getMessage(Locale.getDefault(), key);
    }
    
    /**
     *  Get the message from the key.
     *
     *  @param key the message key
     *  @param arg0 object to replace 0th item in the message
     *  @return message
     */
    public static String getMessage(String key, Object arg0) {
        return getMessage(Locale.getDefault(), key, arg0);
    }
    
    /**
     *  Get the message from the key.
     *
     *  @param key the message key
     *  @param arg0 object to replace 0th item in the message
     *  @param arg1 object to replace 1st item in the message
     *  @return message
     */
    public static String getMessage(String key, Object arg0, Object arg1) {
        return getMessage(Locale.getDefault(), key, arg0, arg1);
    }
    
    /**
     *  Get the message from the key.
     *
     *  @param key the message key
     *  @param arg0 object to replace 0th item in the message
     *  @param arg1 object to replace 1st item in the message
     *  @param arg2 object to replace 2nd item in the message
     *  @return message
     */
    public static String getMessage(
            String key, Object arg0, Object arg1, Object arg2) {
        return getMessage(Locale.getDefault(), key, arg0, arg1, arg2);
    }
    
    /**
     *  Get the message from the key.
     *
     *  @param key the message key
     *  @param arg0 object to replace 0th item in the message
     *  @param arg1 object to replace 1st item in the message
     *  @param arg2 object to replace 2nd item in the message
     *  @param arg3 object to replace 3rd item in the message
     *  @return message
     */
    public static String getMessage(
            String key, Object arg0, Object arg1, Object arg2, Object arg3) {
        return getMessage(Locale.getDefault(), key, arg0, arg1, arg2, arg3);
    }
    
    /**
     *  Get the message from the key.
     *
     *  @param key the message key
     *  @param args objects to replace items in the message
     *  @return message
     */
    public static String getMessage(String key, Object[] args) {
        return getMessage(Locale.getDefault(), key, args);
    }

    /**
     *  Get the message from the key.
     *
     *  @param locale the message locale
     *  @param key the message key
     *  @return message
     */
    public static String getMessage(Locale locale, String key) {
        return getBundle(locale).getString(key);
    }

    /**
     *  Get the message from the key.
     *
     *  @param locale the message locale
     *  @param key the message key
     *  @param arg0 object to replace 0th item in the message
     *  @return message
     */
    public static String getMessage(Locale locale, String key, Object arg0) {
        return getMessage(locale, key, new Object[] {arg0});
    }

    /**
     *  Get the message from the key.
     *
     *  @param locale the message locale
     *  @param key the message key
     *  @param arg0 object to replace 0th item in the message
     *  @param arg1 object to replace 1st item in the message
     *  @return message
     */
    public static String getMessage(
            Locale locale, String key, Object arg0, Object arg1) {
        return getMessage(locale, key, new Object[] {arg0, arg1});
    }

    /**
     *  Get the message from the key.
     *
     *  @param locale the message locale
     *  @param key the message key
     *  @param arg0 object to replace 0th item in the message
     *  @param arg1 object to replace 1st item in the message
     *  @param arg2 object to replace 2nd item in the message
     *  @return message
     */
    public static String getMessage(
            Locale locale, String key, Object arg0, Object arg1, Object arg2) {
        return getMessage(locale, key, new Object[] {arg0, arg1, arg2});
    }

    /**
     *  Get the message from the key.
     *
     *  @param locale the message locale
     *  @param key the message key
     *  @param arg0 object to replace 0th item in the message
     *  @param arg1 object to replace 1st item in the message
     *  @param arg2 object to replace 2nd item in the message
     *  @param arg3 object to replace 3rd item in the message
     *  @return message
     */
    public static String getMessage(
            Locale locale, String key,
            Object arg0, Object arg1, Object arg2, Object arg3) {
        return getMessage(locale, key, new Object[] {arg0, arg1, arg2, arg3});
    }

    /**
     *  Get the message from the key.
     *
     *  @param locale the message locale
     *  @param key the message key
     *  @param args objects to replace items in the message
     *  @return message
     */
    public static String getMessage(Locale locale, String key, Object[] args) {
        return MessageFormat.format(getBundle(locale).getString(key), args);
    }

    /**
     *  get the property file by locale.
     *
     *  @param locale locale
     *  @return property file
     */
    private static ResourceBundle getBundle(Locale locale) {
        synchronized (MessageResources.resourceMap) {
            ResourceBundle resource = (ResourceBundle)
                MessageResources.resourceMap.get(locale);
            if (resource == null) {
                resource = ResourceBundle.getBundle(
                    MessageResources.RESOURCE_NAME, locale);
                MessageResources.resourceMap.put(locale, resource);
            }
            return resource;
        }
    }
}
