/*                          
 * mBench: The Open Source Micro Benchmark Tool 
 *                                             
 * Distributable under GPL license. 
 * See terms of license at gnu.org.                 
 *
 * Copyright (C) 2005 Sumisho Computer Systems Corp.
 */
package jp.co.scs.mbench;

/**
 *      The exception for terminating the benchmark
 * 
 *      @author Masato Koga
 */
public class ThreadTerminateException extends Exception {
    /**
     *  Creates a exception for terminating the benchmark instance.
     */
    public ThreadTerminateException() {
        super();
    }

    /**
     *  Creates a exception for terminating the benchmark instance with message.
     *
     *  @param message message
     */
    public ThreadTerminateException(String message) {
        super(message);
    }

    /**
     *  Creates a exception for terminating the benchmark instance with message and cause.
     *
     *  @param message message
     *  @param cause cause
     */
    public ThreadTerminateException(String message, Throwable cause) {
        super(message, cause);
    }

    /**
     *  Creates a exception for terminating the benchmark instance with cause.
     *
     *  @param cause cause
     */
    public ThreadTerminateException(Throwable cause) {
        super(cause);
    }
}
