/*                          
 * mBench: The Open Source Micro Benchmark Tool 
 *                                             
 * Distributable under GPL license. 
 * See terms of license at gnu.org.                 
 *
 * Copyright (C) 2005 Sumisho Computer Systems Corp.
 */
package test.jp.co.scs.mbench;

import jp.co.scs.mbench.BenchmarkTerminateException;
import jp.co.scs.mbench.CSVAsynchronousDataWriter;
import junit.framework.TestCase;

/**
 *      @author Tetsuro Ikeda
 */
public class CSVAsynchronousDataWriterTest extends TestCase {

    private static final String DATA_NAME = "test.csv";

    private static final String EXPECT_FILE_NAME =
        "data/CSVAsynchronousDataWriter/test.csv";
    
    /**
     *  Log writer thread must be started after calling this method.
     */
    public void testInit() {
        CSVAsynchronousDataWriter csvAsynchronousDataWriter =
            new CSVAsynchronousDataWriter(DATA_NAME);
        try {
            csvAsynchronousDataWriter.init();
            assertTrue(csvAsynchronousDataWriter.isInitialized());
        } catch (BenchmarkTerminateException ex) {
            fail(ex.getMessage());
        } finally {
            csvAsynchronousDataWriter.clean();
            FileUtil.deleteFile(DATA_NAME);
        }
    }
    
    /**
     *  Data log must be inserted in the queue after calling this method.
     */
    public void testWrite() {
        CSVAsynchronousDataWriter csvAsynchronousDataWriter =
            new CSVAsynchronousDataWriter(DATA_NAME);
        try {
            csvAsynchronousDataWriter.init();
            String[] data = new String[3];
            data[0] = "hoge";
            data[1] = "foo";
            data[2] = "bar";
            csvAsynchronousDataWriter.write(data);
            csvAsynchronousDataWriter.write(data);
            csvAsynchronousDataWriter.write(data);

            assertEquals(3, csvAsynchronousDataWriter.getDataQueueSize());
        } catch (BenchmarkTerminateException ex) {
            fail(ex.getMessage());
        } catch (Exception ex) {
            fail(ex.getMessage());
        } finally {
            csvAsynchronousDataWriter.clean();
            FileUtil.deleteFile(DATA_NAME);
        }
    }
    
    /**
     *  The data log in the queue must be printed out as CVS format.
     */
    public void testRun() {
        CSVAsynchronousDataWriter csvAsynchronousDataWriter =
            new CSVAsynchronousDataWriter(DATA_NAME);
        try {
            csvAsynchronousDataWriter.init();
            String[] data = new String[3];
            data[0] = "hoge";
            data[1] = "foo";
            data[2] = "bar";
            csvAsynchronousDataWriter.write(data);
            csvAsynchronousDataWriter.write(data);
            csvAsynchronousDataWriter.write(data);
            csvAsynchronousDataWriter.clean();

            assertTrue(FileUtil.compareFiles(EXPECT_FILE_NAME, DATA_NAME));
        } catch (BenchmarkTerminateException ex) {
            fail(ex.getMessage());
        } catch (Exception ex) {
            fail(ex.getMessage());
        } finally {
            FileUtil.deleteFile(DATA_NAME);
        }
    }
    
    /**
     *  Log writer thread must finish after calling this method.
     */
    public void testClean() {
        CSVAsynchronousDataWriter csvAsynchronousDataWriter =
            new CSVAsynchronousDataWriter(DATA_NAME);
        try {
            csvAsynchronousDataWriter.init();
            String[] data = new String[3];
            data[0] = "hoge";
            data[1] = "foo";
            data[2] = "bar";
            csvAsynchronousDataWriter.write(data);
            csvAsynchronousDataWriter.write(data);
            csvAsynchronousDataWriter.write(data);
            csvAsynchronousDataWriter.clean();

            assertFalse(csvAsynchronousDataWriter.isRunning());
        } catch (BenchmarkTerminateException ex) {
            fail(ex.getMessage());
        } catch (Exception ex) {
            fail(ex.getMessage());
        } finally {
            FileUtil.deleteFile(DATA_NAME);
        }
    }
}
