/*                          
 * mBench: The Open Source Micro Benchmark Tool 
 *                                             
 * Distributable under GPL license. 
 * See terms of license at gnu.org.                 
 *
 * Copyright (C) 2005 Sumisho Computer Systems Corp.
 */
package test.jp.co.scs.mbench;

import jp.co.scs.mbench.BenchmarkAbortException;
import jp.co.scs.mbench.BenchmarkTerminateException;
import jp.co.scs.mbench.InitializeManager;
import jp.co.scs.mbench.Initializer;
import jp.co.scs.mbench.InitializerInfo;
import junit.framework.TestCase;
import test.jp.co.scs.mbench.stub.StubInitializeManager01;

/**
 *      @author Tetsuro Ikeda
 */
public class InitializeManagerTest extends TestCase {

    private static final String INITIALIZER_NAME1 = "StubInitializeManager01";
    
    private static final String INITIALIZER_NAME2 = "StubInitializeManager02";
    
    private static final String INITIALIZER_CLASS_NAME =
        "test.jp.co.scs.mbench.stub.StubInitializeManager01";

    private static final String INITIALIZER_WRONG_CLASS_NAME =
        "test.jp.co.scs.mbench.stub.hoge";

    private static final String CONFIGURATION_FILE_NAME = "conf/mbench.xml";

    private static final String TEST_CONFIGURATION_FILE_NAME1 = 
        "data/InitializeManager/executeTest01/mbench.xml";
    
    private static final String TEST_CONFIGURATION_FILE_NAME2 = 
        "data/InitializeManager/executeTest02/mbench.xml";

    private static final String DEFAULT_DIR = "conf";

    private static final String TEMP_DIR = "temp";
    
    /**
     *  Get the initializer instance speficied by initializer information.
     */
    public void testGetInIitializer() {
        try {
            InitializerInfo initializerInfo = new InitializerInfo();
            initializerInfo.setClassName(INITIALIZER_CLASS_NAME);
            InitializeManager initializeManager =
                new InitializeManager(INITIALIZER_NAME1);
            Initializer inititilizer = 
                initializeManager.getInitializer(initializerInfo);
            
            assertEquals(INITIALIZER_CLASS_NAME, inititilizer.getClass().getName());
        } catch (Exception ex) {
            fail(ex.getMessage());
        }
    } 
    
    /**
     *  BenchmarkAbortException must be thrown if the initializer instance
     *  couldn't be get by initializer information.
     */
    public void testGetInitializer2() {
        try {
            InitializerInfo initializerInfo = new InitializerInfo();
            initializerInfo.setClassName(INITIALIZER_WRONG_CLASS_NAME);
            InitializeManager initializeManager =
                new InitializeManager(INITIALIZER_NAME1);
            initializeManager.getInitializer(initializerInfo);
            fail();
        } catch (BenchmarkAbortException ex) {
            assertTrue(BenchmarkAbortException.class.
                    isAssignableFrom(ex.getClass()));
        } catch (Exception ex) {
            fail(ex.getMessage());
        }
    }
    
    /**
     *  Execute the initializer.
     */
    public void testExecute() {
        try {
            FileUtil.copyFiles(CONFIGURATION_FILE_NAME, TEMP_DIR);
            FileUtil.deleteFile(CONFIGURATION_FILE_NAME);
            FileUtil.copyFiles(TEST_CONFIGURATION_FILE_NAME1, DEFAULT_DIR);
            InitializeManager initializeManager =
                new InitializeManager(INITIALIZER_NAME1);
            initializeManager.execute();
            Initializer initializer = 
                initializeManager.getInitializer();

            assertTrue(((StubInitializeManager01)initializer).isExecuteFlg());
        } catch (BenchmarkAbortException ex) {
            fail(ex.getMessage());
        } catch (Exception ex) {
            fail(ex.getMessage());
        } finally {
            try {
                FileUtil.copyFiles(TEMP_DIR, DEFAULT_DIR);
            } catch (Exception ex) {
                fail(ex.getMessage());
            } finally {
                FileUtil.deleteFile(TEMP_DIR);
            }
        }
    }
    
    /**
     *  BenchmarkTerminateException must be thrown if initializer failed.
     */
    public void testExecute2() {
         try {   
            FileUtil.copyFiles(CONFIGURATION_FILE_NAME, TEMP_DIR);
            FileUtil.deleteFile(CONFIGURATION_FILE_NAME);
            FileUtil.copyFiles(TEST_CONFIGURATION_FILE_NAME2, DEFAULT_DIR);
            InitializeManager initializeManager =
                new InitializeManager(INITIALIZER_NAME2);
            initializeManager.execute();
            initializeManager.getInitializer();
            fail();
        } catch (BenchmarkTerminateException ex) {
            assertTrue(BenchmarkTerminateException.class.
                    isAssignableFrom(ex.getClass()));
        } catch (Exception ex) {
            fail(ex.getMessage());
        } finally {
            try {
                FileUtil.copyFiles(TEMP_DIR, DEFAULT_DIR);
            } catch (Exception ex) {
                fail(ex.getMessage());
            } finally {
                FileUtil.deleteFile(TEMP_DIR);
            }
        }
    }
}
