/*                          
 * mBench: The Open Source Micro Benchmark Tool 
 *                                             
 * Distributable under GPL license. 
 * See terms of license at gnu.org.                 
 *
 * Copyright (C) 2005 Sumisho Computer Systems Corp.
 */
package test.jp.co.scs.mbench.jdbc;

import jp.co.scs.mbench.jdbc.DataSourceManager;
import junit.framework.TestCase;
import test.jp.co.scs.mbench.FileUtil;

/**
 *      @author Tetsuro Ikeda
 */
public class DataSourceManagerTest extends TestCase {

    private static final String DATA_SOURCE_NAME = "a4";
    
    private static final String CONFIGURATION_FILE_NAME = "conf/mbench.xml";
    
    private static final String TEST_CONFIGURATION_FILE_NAME = 
        "data/DataSourceManager/getDataSourceTest01/mbench.xml";
    
    private static final String DEFAULT_DIR = "conf";
    
    private static final String TEMP_DIR = "temp";
    
    /**
     *  Get the data source by specified name.
     */
    public void testGetDataSource() {
        try {
            FileUtil.copyFiles(CONFIGURATION_FILE_NAME, TEMP_DIR);
            FileUtil.deleteFile(CONFIGURATION_FILE_NAME);
            FileUtil.copyFiles(TEST_CONFIGURATION_FILE_NAME, DEFAULT_DIR);
            assertNotNull(DataSourceManager.getDataSource(DATA_SOURCE_NAME));
        } catch (Exception ex) {
            fail(ex.getMessage());
        } finally {
            try {
                FileUtil.copyFiles(TEMP_DIR, DEFAULT_DIR);
            } catch (Exception ex) {
                fail(ex.getMessage());
            } finally {
                FileUtil.deleteFile(TEMP_DIR);
            }
        } 
    }
}
