/*                          
 * mBench: The Open Source Micro Benchmark Tool 
 *                                             
 * Distributable under GPL license. 
 * See terms of license at gnu.org.                 
 *
 * Copyright (C) 2005 Sumisho Computer Systems Corp.
 */
package test.jp.co.scs.mbench.stub;

import jp.co.scs.mbench.BenchmarkContainer;
import jp.co.scs.mbench.BenchmarkInfo;
import jp.co.scs.mbench.BenchmarkTerminateException;
import jp.co.scs.mbench.DataWriter;
import jp.co.scs.mbench.LogWriter;
import jp.co.scs.mbench.BenchmarkState;
import jp.co.scs.mbench.Synchronizer;

/**
 *      The stub for testing BenchmarkManager.
 *      Normal execution.
 * 
 *      @author Tetsuro Ikeda
 */
public class StubBenchmarkManagerContainer extends BenchmarkContainer {

    public StubBenchmarkManagerContainer(int containerID, BenchmarkInfo info, Synchronizer synchronizer, LogWriter logWriter, DataWriter dataWriter) {
        super(containerID, info, synchronizer, logWriter, dataWriter);
    }

    public void initTarget() throws BenchmarkTerminateException {
        this.currentState = BenchmarkState.INITIALIZING;
        try {
            Thread.sleep(40 + getRandom(10));
        } catch (InterruptedException ex) {
            // ignore
        }
        this.currentState = BenchmarkState.INITIALIZED;
        this.isInitialized = true;
    }
    
    public void executeTarget() {
        this.currentState = BenchmarkState.RUNNING;
        try {
            Thread.sleep(500 + getRandom(100));
        } catch (InterruptedException ex) {
            // ignore
        }
        this.currentState = BenchmarkState.FINISHED;
    }
    
    public void cleanTarget() {
        this.currentState = BenchmarkState.CLEANING;
        try {
            Thread.sleep(getRandom(10));
        } catch (InterruptedException ex) {
            // ignore
        }
        this.currentState = BenchmarkState.CLEANED;
    }

    protected int getRandom(int max) {
        return (int) Math.random() * max;
    }

}
