/*                          
 * mBench: The Open Source Micro Benchmark Tool 
 *                                             
 * Distributable under GPL license. 
 * See terms of license at gnu.org.                 
 *
 * Copyright (C) 2005 Sumisho Computer Systems Corp.
 */
package test.jp.co.scs.mbench.stub;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;

/**
 *      The stub behave as secondary node.
 * 
 *      @author Tetsuro Ikeda
 */
public class StubBenchmarkManagerSecondaryNode3 extends
        StubBenchmarkManagerSecondaryNode {

    public StubBenchmarkManagerSecondaryNode3(int port) {
        super(port);
    }

    public void run() {
        try {
            ServerSocket server = new ServerSocket(this.port);
            server.setSoTimeout(5000);
            Socket socket = server.accept();
            socket.setSoTimeout(5000);
            byte[] buffer = new byte[20];
            InputStream is = socket.getInputStream();
            OutputStream os = socket.getOutputStream();
            is.read(buffer);
            buffer = trimBlankByte(buffer);
            String message = new String(buffer);
            this.messageList.add(message);

            os.write(new String("doInit OK").getBytes());
            byte[] buffer2 = new byte[20];
            is.read(buffer2);
            buffer2 = trimBlankByte(buffer2);
            String message2 = new String(buffer2);
            this.messageList.add(message2);
            
        } catch (IOException ex) {
            this.messageList.add(ex.getMessage());
            ex.printStackTrace();
        }
    }
    
}