/*                          
 * mBench: The Open Source Micro Benchmark Tool 
 *                                             
 * Distributable under GPL license. 
 * See terms of license at gnu.org.                 
 *
 * Copyright (C) 2005 Sumisho Computer Systems Corp.
 */
package test.jp.co.scs.mbench.stub;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Properties;
;

/**
 *      @author Toshio Sugahara
 */
public class StubDataSourceImpl03
        implements Driver {

    private static final String USER_KEY = "user";

    private static final String PASSWORD_KEY = "password";

    private static String db_user = null;

    private static String db_password = null;

    private static int sleepTime = 0;

    static {
        try {
            java.sql.DriverManager.registerDriver(new StubDataSourceImpl03());
        } catch (SQLException E) {
            throw new RuntimeException("Can't register driver!");
        }
    }
    

    public static String getUser() {
        return StubDataSourceImpl03.db_user;
    }
    
    public static void setUser(String user) {
        StubDataSourceImpl03.db_user = user;
    }
    
    public static String getPassword() {
        return StubDataSourceImpl03.db_password;
    }

    public static void setPassword(String password) {
        StubDataSourceImpl03.db_password = password;
    }
    
    public static int getSleepTime() {
        return StubDataSourceImpl03.sleepTime;
    }
    
    public static void setSleepTime(int sleepTime) {
        StubDataSourceImpl03.sleepTime = sleepTime;
    }
    
    public int getMajorVersion() {
        return 0;
    }

    public int getMinorVersion() {
        return 0;
    }

    public boolean jdbcCompliant() {
        return false;
    }

    public boolean acceptsURL(String url)
            throws SQLException {
        return false;
    }


    public Connection connect(String url, Properties prop)
            throws SQLException {
        try {
            wait(sleepTime);
        } catch (InterruptedException e) {
            //e.printStackTrace();
        }
        db_user = prop.getProperty(USER_KEY);
        db_password = prop.getProperty(PASSWORD_KEY);
        StubDataSourceImplConnection connection = 
            new StubDataSourceImplConnection();
        
        return connection;
    }

    public DriverPropertyInfo[] getPropertyInfo(
            String arg0, Properties arg1) 
            throws SQLException {
        return null;
    }
}
