/*
 * Copyright (C) 2003 ASANO Masahiro
 */

#include "def.h"

#define __KERNEL__
#include <linux/genhd.h>

void
prhead_hd_struct()
{
	mprintf(SPTR"  #  START_SECT    NR_SECTS\n", "ADDR");
}


addr_t
print_hd_struct(addr, num)
	addr_t addr;
	int num;
{
	struct hd_struct part;

	memread(addr, sizeof(part), &part, "hd_struct");
	if (part.start_sect == 0 && part.nr_sects == 0)
		return 0;
	mprintf(FPTR " %2x %11llx %11llx\n",
		addr, num, (__u64)part.start_sect, (__u64)part.nr_sects);
	return 1;
}

void
prhead_gendisk()
{
	mprintf(SPTR" MAJ(MAX) "SPTR" "SPTR" NR_REAL "SPTR" "SPTR" NAME\n",
		"ADDR", "PART", "SIZES", "REAL_DEV", "FOPS");
}

addr_t
print_gendisk(addr, full)
	addr_t addr;
	int full;
{
	struct gendisk disk;
	char buf[32];

	memread(addr, sizeof(disk), &disk, "gendisk");

	mprintf(FPTR " %3d(%3d) ", addr, disk.major, disk.max_p);
	mprintf(FPTR " " FPTR " ", disk.part, disk.sizes);
	mprintf("%7x ", disk.nr_real);
	mprintf(FPTR " " FPTR " ", disk.real_devices, disk.fops);
	memread((addr_t)disk.major_name, sizeof(buf), buf, "major_name");
	mprintstr(buf, sizeof(buf));
	mprintf("\n");

	if (full) {
		int i;

		mprintf("major,minor  %d %d %d\n",
			disk.major, disk.minor_shift, disk.max_p);
		mprintf("major_name   " FPTR "\n", disk.major_name);
		mprintf("part         " FPTR "\n", disk.part);
		mprintf("sizes        " FPTR "\n", disk.sizes);
		mprintf("nr_real      %x\n", disk.nr_real);
		mprintf("real_devices " FPTR "\n", disk.real_devices);
		mprintf("fops         " FPTR "  (operations -b)\n", disk.fops);
		mprintf("de_arr       " FPTR "\n", disk.de_arr);
		mprintf("flags        " FPTR "\n", disk.flags);

		prhead_hd_struct();
		for (i = 0; i < disk.max_p; i++) {
			print_hd_struct((addr_t)disk.part + i * sizeof(struct hd_struct), i);
		}
	}

	return (addr_t)disk.next;
}
