/*
 * Copyright (C) 2000-2003 ASANO Masahiro
 */

#include "def.h"

#define __KERNEL__
#include <linux/fs.h>
#include <linux/mm.h>
#include <linux/sched.h>
#include <linux/module.h>
#include <linux/blkdev.h>
#include <linux/slab.h>
#include <linux/vmalloc.h>
#include <linux/socket.h>
#include <linux/skbuff.h>
#include <asm/uaccess.h>
#if defined(CONFIG_INET)
#include <linux/in.h>
#endif
#if defined(CONFIG_BLK_DEV_LVM) || defined(CONFIG_BLK_DEV_LVM_MODULE)
#include <linux/lvm.h>
#endif
#if defined(CONFIG_SUNRPC) || defined(CONFIG_SUNRPC_MODULE)
#include <linux/sunrpc/svc.h>
#endif

#include "slab.h"

struct sizetbl sizetbl[] = {
	{ "char",		sizeof(char) },
	{ "short",		sizeof(short) },
	{ "int",		sizeof(int) },
	{ "long",		sizeof(long) },
	{ "longlong",		sizeof(long long) },
	{ "*",			sizeof(void*) },

	{ "address_space",	sizeof(struct address_space) },
	{ "atomic_t",		sizeof(atomic_t) },
	{ "blk_dev_struct",	sizeof(struct blk_dev_struct) },
	{ "block_device",	sizeof(struct block_device) },
	{ "buffer_head",	sizeof(struct buffer_head) },
	{ "caddr_t",		sizeof(caddr_t) },
	{ "dentry",		sizeof(struct dentry) },
	{ "dev_t",		sizeof(dev_t) },
	{ "exception_table_entry", sizeof(struct exception_table_entry) },
	{ "ext2_inode_info",	sizeof(struct ext2_inode_info) },
	{ "ext2_sb_info",	sizeof(struct ext2_sb_info) },
	{ "fd_set",		sizeof(fd_set) },
	{ "file",		sizeof(struct file) },
	{ "file_lock",		sizeof(struct file_lock) },
	{ "file_system_type",	sizeof(struct file_system_type) },
	{ "files_struct",	sizeof(struct files_struct) },
	{ "fs_struct",		sizeof(struct fs_struct) },
	{ "gid_t",		sizeof(gid_t) },
	{ "ino_t",		sizeof(ino_t) },
	{ "inode",		sizeof(struct inode) },
	{ "k_sigaction",	sizeof(struct k_sigaction) },
	{ "kdev_t",		sizeof(kdev_t) },
	{ "kmem_cache_t",	sizeof(kmem_cache_t) },
	{ "list_head",		sizeof(struct list_head) },
	{ "loff_t",		sizeof(loff_t) },
#if defined(CONFIG_BLK_DEV_LVM) || defined(CONFIG_BLK_DEV_LVM_MODULE)
	{ "lv_disk_t",		sizeof(lv_disk_t) },
	{ "lv_t",		sizeof(lv_t) },
#endif
	{ "mem_map_t",		sizeof(mem_map_t) },
	{ "mm_struct",		sizeof(struct mm_struct) },
	{ "module",		sizeof(struct module) },
	{ "nameidata",		sizeof(struct nameidata) },
	{ "nfs_fh",		sizeof(struct nfs_fh) },
	{ "nfs_sb_info",	sizeof(struct nfs_sb_info) },
	{ "nlink_t",		sizeof(nlink_t) },
	{ "page",		sizeof(struct page) },
	{ "pgd_t",		sizeof(pgd_t) },
	{ "pglist_data",	sizeof(struct pglist_data) },
	{ "pte_t",		sizeof(pte_t) },
#if defined(CONFIG_BLK_DEV_LVM) || defined(CONFIG_BLK_DEV_LVM_MODULE)
	{ "pv_disk_t",		sizeof(pv_disk_t) },
	{ "pv_t",		sizeof(pv_t) },
#endif
	{ "request",		sizeof(struct request) },
	{ "request_queue",	sizeof(struct request_queue) },
	{ "semaphore",		sizeof(struct semaphore) },
	{ "sigaction",		sizeof(struct sigaction) },
	{ "signal_struct",	sizeof(struct signal_struct) },
	{ "sigpending",		sizeof(struct sigpending) },
	{ "sigset_t",		sizeof(sigset_t) },
	{ "size_t",		sizeof(size_t) },
	{" sk_buff",		sizeof(struct sk_buff) },
	{ "slab_t",		sizeof(slab_t) },
	{ "sockaddr",		sizeof(struct sockaddr) },
#if defined(CONFIG_INET)
	{ "sockaddr_in",	sizeof(struct sockaddr_in) },
#endif
	{ "socket",		sizeof(struct socket) },
	{ "spinlock_t",		sizeof(spinlock_t) },
	{ "super_block",	sizeof(struct super_block) },
#if defined(CONFIG_SUNRPC) || defined(CONFIG_SUNRPC_MODULE)
	{ "svc_rqst",		sizeof(struct svc_rqst) },
	{ "svc_serv",		sizeof(struct svc_serv) },
#endif
	{ "task_struct",	sizeof(struct task_struct) },
	{ "thread_struct",	sizeof(struct thread_struct) },
	{ "time_t",		sizeof(time_t) },
	{ "tq_struct",		sizeof(struct tq_struct) },
	{ "uid_t",		sizeof(uid_t) },
	{ "umode_t",		sizeof(umode_t) },
	{ "vfsmount",		sizeof(struct vfsmount) },
#if defined(CONFIG_BLK_DEV_LVM) || defined(CONFIG_BLK_DEV_LVM_MODULE)
	{ "vg_disk_t",		sizeof(vg_disk_t) },
	{ "vg_t",		sizeof(vg_t) },
#endif
	{ "vm_area_struct",	sizeof(struct vm_area_struct) },
	{ "vm_struct",		sizeof(struct vm_struct) },
	{ "wait_queue_head_t",	sizeof(wait_queue_head_t) },
	{ "wait_queue_t",	sizeof(wait_queue_t) },
	{ "zone_t",		sizeof(zone_t) },
};
int sizetbl_size = sizeof(sizetbl) / sizeof(sizetbl[0]);
