/*
 * Copyright (C) 2000-2002 ASANO Masahiro
 */

#include "def.h"

#define __KERNEL__
#include <linux/fs.h>
#include <linux/ext2_fs.h>

addr_t
print_ext2_inode(addr)
	addr_t addr;
{
	struct ext2_inode e2i;
	int i;

	memread(addr, sizeof(e2i), &e2i, "ext2_inode");
	mprintf("data:");
	mprintf("mode:                 %04x\n", e2i.i_mode);
	mprintf("uid:                  %04x\n", e2i.i_uid);
	mprintf("size:             %08x\n", e2i.i_size);
	mprintf("atime:            %08x\n", e2i.i_atime);
	mprintf("ctime:            %08x\n", e2i.i_ctime);
	mprintf("mtime:            %08x\n", e2i.i_mtime);
	mprintf("dtime:            %08x\n", e2i.i_dtime);
	mprintf("gid:                  %04x\n", e2i.i_gid);
	mprintf("links_count:          %04x\n", e2i.i_links_count);
	mprintf("blocks:           %08x\n", e2i.i_blocks);
	mprintf("flags:            %08x\n", e2i.i_flags);
	for (i = 0; i < LENGTHOF(e2i.i_block); i++) {
		mprintf(" %8x", e2i.i_block[i]);
		if (i == 7) {
			mprintf("\n     ");
		}
	}
	mprintf("\n");
	mprintf("generation:       %08x\n", e2i.i_generation);
	mprintf("file_acl:         %08x\n", e2i.i_file_acl);
	mprintf("dir_acl:          %08x\n", e2i.i_dir_acl);
	mprintf("faddr:            %08x\n", e2i.i_faddr);
	return 0;
}
