/*
 * Copyright (C) 2000-2002 ASANO Masahiro
 */

#include <unistd.h>
#include <string.h>
#include "crash.h"

PRIVATE addr_t sizeof_cmd();
const commandtable_t command_sizeof =
	{"sizeof", sizeof_cmd, "[tables]", "print size of various tables"};

static const char head_sizeof[] = "           TYPE NAME    DEC   HEX\n";

PRIVATE addr_t
sizeof_cmd()
{
	int c, i;

	while ((c = getopt(argcnt, args, "")) != EOF) {
		THROW(usage);
	}

	mprintf(head_sizeof);
	if (argcnt == optind) {
		for (i = 0; i < sizetbl_size; i++) {
			mprintf("%20s %6u %5x\n", sizetbl[i].name, sizetbl[i].size, sizetbl[i].size);
		}
		mprintf(head_sizeof);
	} else {
		while (args[optind]) {
			for (i = 0; i < sizetbl_size; i++) {
				if (strcmp(args[optind], sizetbl[i].name) == 0)
					break;
			}
			if (i >= sizetbl_size) {
				THROWF("unknown type name: %s", args[optind]);
			}
			mprintf("%20s %6u %5x\n", sizetbl[i].name, sizetbl[i].size, sizetbl[i].size);
			optind++;
		}
	}
	return 0;
}

int
sizeof_func(sym)
const char *sym;
{
	int i;

	for (i = 0; i < sizetbl_size; i++) {
		if (strcmp(sym, sizetbl[i].name) == 0)
			return sizetbl[i].size;
	}
	THROWF("unknown type name: %s", sym);
}
