/*
 * Copyright (C) 2000-2002 ASANO Masahiro
 */

#include <unistd.h>
#include "crash.h"

#include <linux/timer.h>

/* BEGIN "linux/kernel/timer.c" */

#define TVN_BITS 6
#define TVR_BITS 8
#define TVN_SIZE (1 << TVN_BITS)
#define TVR_SIZE (1 << TVR_BITS)
#define TVN_MASK (TVN_SIZE - 1)
#define TVR_MASK (TVR_SIZE - 1)

typedef struct tvec_s {
	int index;
	struct list_head vec[TVN_SIZE];
} tvec_t;

typedef struct tvec_root_s {
	int index;
	struct list_head vec[TVR_SIZE];
} tvec_root_t;

struct tvec_t_base_s {
	struct { int dummy; } lock;
	unsigned long timer_jiffies;
	void *running_timer;
	tvec_root_t tv1;
	tvec_t tv2;
	tvec_t tv3;
	tvec_t tv4;
	tvec_t tv5;
};

/* END "linux/kernel/timer.c" */

PRIVATE addr_t timer_vec();
const commandtable_t command_timer_vec =
	{"timer_vec", timer_vec, "", "print timer_vec table (tv1-tv5)"};

addr_t tvec_bases_addr;	/* per_cpu ... but not yet */
addr_t jiffies_addr;

void
prhead_timer_vec()
{
	 mprintf("SLOT: "SPTR"  EXPIRES  FUNCTION (ARGUMENT)\n", "ADDRESS");
}

void
print_timer_vec(tvn, addr)
	int tvn;
	addr_t addr;
{
	int i;
	struct tvec_root_s tv;
	struct timer_list tl;
	addr_t vec;
	const char *p;

	/* sizeof(timer_vec) < sizeof(timer_vec_root) */
	memread(addr, sizeof(struct tvec_root_s), &tv, "timer_vec");

	mprintf("\ntv%x  (%lx)  index: %d\n", tvn, addr, tv.index);
	prhead_timer_vec();
	for (i = 0; i < ((tvn == 1)? TVR_SIZE: TVN_SIZE); i++) {
		for (vec = (addr_t)tv.vec[i].next; vec; vec = (addr_t)tl.entry.next) {
			if (vec >= addr && vec < addr + sizeof(struct tvec_root_s))
				break;
			memread(vec, sizeof(struct timer_list), &tl, "timer_list");
			if (tl.entry.next == tv.vec[i].next)
				break;
			mprintf("%4d: " FPTR, i, vec);
			mprintf(" %8lx", tl.expires);
			p = getsymstr((addr_t)tl.function);
			if (p) {
				mprintf("  %s (%lx)\n", p, tl.data);
			} else {
				mprintf("  %lx (%lx)\n", tl.function, tl.data);
			}
		}
	}
}

PRIVATE addr_t
timer_vec()
{
	int i, c;
	char buf[32];
	unsigned long jiffies;

	while ((c = getopt(argcnt, args, "")) != EOF) {
		switch (c) {
		default:
			THROW(usage);
		}
	}

	if (optind != argcnt)
		THROW(usage);

	GETADDR(tvec_bases);
	GETADDR(jiffies);
	memread(jiffies_addr, sizeof(jiffies), &jiffies, "jiffies");
	mprintf("jiffies = %lx\n", jiffies);

	/*NR_CPUS*/
	{
		print_timer_vec(1, tvec_bases_addr + OFFSET(struct tvec_t_base_s, tv1));
		print_timer_vec(2, tvec_bases_addr + OFFSET(struct tvec_t_base_s, tv2));
		print_timer_vec(3, tvec_bases_addr + OFFSET(struct tvec_t_base_s, tv3));
		print_timer_vec(4, tvec_bases_addr + OFFSET(struct tvec_t_base_s, tv4));
		print_timer_vec(5, tvec_bases_addr + OFFSET(struct tvec_t_base_s, tv5));
	}
	return 0;
}
