/*
 * Copyright (C) 2000-2002 ASANO Masahiro
 */

#include "def.h"

#define __KERNEL__
#include <xfs.h>

void
prhead_xfs_inode()
{
	mprintf(SPTR"      INO MODE   UID     SIZE "SPTR" "SPTR" PIN UCS FLAGS\n",
		"ADDR", "TRANSP", "ITEMP");
}

addr_t
print_xfs_inode(addr, fflag, rflag)
	addr_t addr;
	int fflag;
	int rflag;
{
	xfs_inode_t i;
	static const struct bitname iflags[] = {
		{ XFS_IGRIO,	"igrio" },
		{ XFS_IUIOSZ,	"iuiosz" },
		{ XFS_IQUIESCE,	"iquiesce" },
		{ XFS_IRECLAIM,	"ireclaim" },
		{ 0,		NULL }
	};

	memread(addr, sizeof(i), &i, "xfs_inode_t");

	if (fflag == 0) {
		mprintf(FPTR " %8lx ", addr, (long)i.i_ino);
		pmode(i.i_d.di_mode);
		mprintf(" %5d %8Lx ", i.i_d.di_uid, i.i_d.di_size);
		mprintf(FPTR " " FPTR,  i.i_transp, i.i_itemp);
		mprintf(" %3x  %c%c ", i.i_pincount,
			i.i_update_core? 'C': '-',
			i.i_update_size? 'S': '-');
		mprintbit(iflags, i.i_flags);
		mprintf("\n");
	} else {
		mprintf("addr     " FPTR "\n", addr);

		mprintf("mount    " FPTR "\n", i.i_mount);
		mprintf("ino          %lx\n", (long)i.i_ino);
		mprintf("blkno        %lx\n", (long)i.i_blkno);
		mprintf("len          %x\n", i.i_len);
		mprintf("boffset      %x\n", i.i_boffset);

		mprintf("df.bytes     %x\n", i.i_df.if_bytes);
		mprintf("df.u1    " FPTR "\n", i.i_df.if_u1.if_extents);

		mprintf("transp   " FPTR "\n", i.i_transp);
		mprintf("itemp    " FPTR "\n", i.i_itemp);
#if 0
		mprintf("refcache " FPTR "\n", i.i_refcache);
		mprintf("release  " FPTR "\n", i.i_release);
#endif

		mprintf("flags        %x\n", i.i_flags);
		mprintf("update_core  %x\n", i.i_update_core);
		mprintf("update_size  %x\n", i.i_update_size);
		mprintf("gen          %x\n", i.i_gen);
		mprintf("delayed_blks %x\n", i.i_delayed_blks);

		mprintf("d.mode       %x\n", i.i_d.di_mode);
		mprintf("d.uid        %d\n", i.i_d.di_uid);
		mprintf("d.size       %Lx\n", i.i_d.di_size);
	}

	if (rflag) {
		return (addr_t)i.i_next;
	}
	return (addr_t)i.i_mnext;
}
