/*
 * Copyright (C) 2000-2002 ASANO Masahiro
 */

#include "def.h"

#define __KERNEL__
#if defined(XFS_OLDDIR)
#define _PAGE_BUF_INTERNAL_
#include <linux/fs.h>
#include <linux/page_buf.h>
#else
#ifdef HAVE_AVL
#include <avl.h>
#endif
#include <page_buf.h>
#endif

#include "flags_pagebuf.h"

extern void prhead_semaphore();
extern addr_t print_semaphore();

void
prhead_pagebuf()
{
	mprintf(SPTR" "SPTR" HD       BN   OFFSET LENG "SPTR" ERR CNT OFFS "SPTR" FLAGS\n",
		"ADDR", "TARGET", "ADDR", "PAGES");
}

addr_t
print_pagebuf(addr, fflag)
	addr_t addr;
	int fflag;
{
	page_buf_t pb;

	memread(addr, sizeof(pb), &pb, "page_buf_t");
	mprintf(FPTR " ", addr);

	mprintf(FPTR, pb.pb_target);
	mprintf(" %2x", pb.pb_hold);
	mprintf(" %8lx", pb.pb_bn);
	mprintf(" %8lx", pb.pb_file_offset);
	mprintf(" %4lx", pb.pb_buffer_length);
	mprintf(" " FPTR, pb.pb_addr);
	mprintf(" %3x", pb.pb_error);
	mprintf(" %3x", pb.pb_page_count);
	mprintf(" %4x", pb.pb_offset);
	mprintf(" " FPTR, pb.pb_pages);
	mprintbit(page_buf_flags_e_bitname, pb.pb_flags);
	mprintf("\n");

	if (fflag) {
		mprintf("  iodone: " FPTR "\n", pb.pb_iodone);
		mprintf("  relse:  " FPTR "\n", pb.pb_relse);
		mprintf("  strat:  " FPTR "\n", pb.pb_strat);
		mprintf("  locked:    %x\n", pb.pb_locked);
		mprintf("  fspriv  " FPTR "\n", pb.pb_fspriv);
		mprintf("  iodonesema:\n");
#if 1
		/* new style */
		prhead_semaphore();
		print_semaphore(addr + OFFSET(page_buf_t, pb_iodonesema));
#else
		/* old fashion */
		prhead_semaphore();
		print_semaphore(addr + OFFSET(struct page_buf_private_s, pb_iodonesema));
		/*struct page_buf_private_s priv;*/
		/*memread(addr, sizeof(priv), &priv, "page_buf_private_t");*/
#endif
	}

	return (addr_t)pb.pb_list.next - OFFSET(page_buf_t, pb_list);
}
