/*
 * Copyright (C) 2003 ASANO Masahiro
 */

#include "def.h"

#define __KERNEL__
#include <linux/genhd.h>

#include "flags_genhd.h"

void
prhead_hd_struct()
{
	mprintf(SPTR"  # P  START_SECT    NR_SECTS    READS READSECT   WRITES WRITESECT\n", "ADDR");
}


addr_t
print_hd_struct(addr, full)
	addr_t addr;
	int full;
{
	struct hd_struct part;

	memread(addr, sizeof(part), &part, "hd_struct");
	mprintf(FPTR " %2x %x %11llx %11llx",
		addr, part.partno, part.policy,
		(__u64)part.start_sect, (__u64)part.nr_sects);
	mprintf(" %8x %8x %8x %8x\n",
		part.reads,  part.read_sectors,
		part.writes, part.write_sectors);
	return 0;
}

addr_t
print_gendisk(addr, full)
	addr_t addr;
	int full;
{
	struct gendisk disk;

	memread(addr, sizeof(disk), &disk, "gendisk");

	mprintf("addr         " FPTR "\n", addr);
	mprintf("major,minor  %d,%d - %d\n", disk.major, disk.first_minor, disk.minors);
	mprintf("disk_name    \"");
	mprintstr(disk.disk_name, sizeof(disk.disk_name));
	mprintf("\"\n");
	mprintf("part         " FPTR "\n", disk.part);
	mprintf("fops         " FPTR "  (operations -b)\n", disk.fops);
	mprintf("queue        " FPTR "  (request_queue)\n", disk.queue);
	mprintf("private_data " FPTR "\n", disk.private_data);
	mprintf("capacity     %llx\n", (long long)disk.capacity);
	mprintf("flags        %x ", disk.flags);
	mprintbit(gdflags, disk.flags);	mprintf("\n");
	mprintf("devfs_name   \"");
	mprintstr(disk.devfs_name, sizeof(disk.devfs_name));
	mprintf("\"\n");
	mprintf("number       %x\n", disk.number);
	mprintf("driverfs_dev " FPTR "  (device)\n", disk.driverfs_dev);
	mprintf("kobj         ");
	mprint_kobject(&disk.kobj);
	mprintf("random       " FPTR "\n", disk.random);
	mprintf("sync_io      %x\n", disk.sync_io);
	mprintf("stamp        %lx\n", disk.stamp);
#ifdef CONFIG_SMP
	mprintf("disk_stats   " FPTR "  (" FPTR ")\n", disk.dkstats,
		~(addr_t)disk.dkstats);
#else
	mprintf("disk_stats   " FPTR "\n", addr+OFFSET(struct gendisk,dkstats));
#endif /*CONFIG_SMP*/

	if (full) {
		addr_t array[256];
		int i, n;

		if ((n = disk.minors) > LENGTHOF(array))
			n = LENGTHOF(array);
		memread((addr_t)disk.part, sizeof(addr_t) * n, array, "hd_struct");
		mprintf(" ");	prhead_hd_struct();
		for (i = 0; i < n; i++) {
			if (array[i] == 0)
				continue;
			mprintf(" ");	print_hd_struct(array[i], 0);
		}
	}
	return 0;
}
