/*
 * Copyright (C) 2000-2005 ASANO Masahiro
 */

#include <unistd.h>
#include "crash.h"

PRIVATE addr_t xfs_alloc_arg();
const commandtable_t command_xfs_alloc_arg =
	{"xfs_alloc_arg", xfs_alloc_arg, "address", "[XFS] print xfs_alloc_arg_t table"};
extern void prhead_xfs_alloc_arg();
extern addr_t print_xfs_alloc_arg();

PRIVATE addr_t
xfs_alloc_arg()
{
	int i, c;
	addr_t addr;

	while ((c = getopt(argcnt, args, "")) != EOF) {
		switch (c) {
		default:
			THROW(usage);
		}
	}

	if (argcnt > optind) {
		for (i = optind; i < argcnt; i++) {
			addr = getvalue(args[i]);
			do {
				addr = print_xfs_alloc_arg(addr);
			} while (addr);
		}
	} else {
		THROW(usage);
	}
	return addr;
}
