/*
 * Copyright (C) 2003 ASANO Masahiro
 */

#include "def.h"

#define __KERNEL__
#include <linux/device.h>

#include "flags_device.h"

void
prhead_kobject()
{
	mprintf("REF "SPTR" "SPTR" "SPTR" "SPTR" NAME\n",
		"PARENT", "KSET", "KTYPE", "DENTRY");
}

addr_t
mprint_kobject(ko)
	struct kobject *ko;
{
	mprintf("%3x " FPTR " " FPTR " " FPTR " " FPTR " ",
#if SUBLEVEL>=9
		ATOMIC_READ(ko->kref.refcount),
#else
		ATOMIC_READ(ko->refcount),
#endif
		ko->parent, ko->kset, ko->ktype, ko->dentry);
	mprintstr(ko->name, sizeof(ko->name));
	mprintf("\n");
	return (addr_t)ko->entry.next;
}

void
prhead_device()
{
#ifdef _device_has_driver_data
	mprintf(SPTR" LIST "SPTR" "SPTR" "SPTR" "SPTR" "SPTR" BUS_ID\n",
		"ADDR", "PARENT", "BUS", "DRIVER", "DRIVER_D", "RELEASE");
#else
	mprintf(SPTR" LIST "SPTR" "SPTR" "SPTR" DETCH "SPTR" BUS_ID\n",
		"ADDR", "PARENT", "BUS", "DRIVER", "RELEASE");
#endif
}

addr_t
print_device(addr, full)
	addr_t addr;
	int full;
{
	struct device dev;

	memread(addr, sizeof(dev), &dev, "device");
	mprintf(FPTR " ", addr);

#if defined(_device_has_node) && defined(_device_has_bus_list)
#define IS_LISTED(list) ((addr_t)dev.list.next != addr + OFFSET(struct device,list))
	mprintf("%c%c%c%c ",
		IS_LISTED(node)       ? 'N': '-',
		IS_LISTED(bus_list)   ? 'B': '-',
		IS_LISTED(driver_list)? 'D': '-',
		IS_LISTED(children)   ? 'C': '-');
#endif

	mprintf(FPTR " ", dev.parent);
	mprintf(FPTR " ", dev.bus);
	mprintf(FPTR " ", dev.driver);
#ifdef _device_has_driver_data
	mprintf(FPTR " ", dev.driver_data);
#else
	mprintf("%5x ", dev.detach_state);
#endif
	mprintf(FPTR " ", dev.release);
	mprintstr(dev.bus_id, sizeof(dev.bus_id));
	mprintf("\n");
	if (full) {
		prhead_kobject();
		mprint_kobject(&dev.kobj);
	}
#ifdef _device_has_node
	return (addr_t)dev.node.next;
#else
	return 0;
#endif
}
