/*
 * Copyright (C) 2000-2002 ASANO Masahiro
 */

#include "def.h"

#define __KERNEL__
#include <linux/fs.h>
#include <linux/mm.h>
#include <linux/sched.h>
#include <linux/module.h>
#include <linux/blkdev.h>

struct sizetbl sizetbl[] = {
	{ "char",		sizeof(char) },
	{ "short",		sizeof(short) },
	{ "int",		sizeof(int) },
	{ "long",		sizeof(long) },
	{ "*",			sizeof(void*) },

#if 0
	{ "address_space",	sizeof(struct address_space) },
#endif
	{ "atomic_t",		sizeof(atomic_t) },
	{ "blk_dev_struct",	sizeof(struct blk_dev_struct) },
#if 0
	{ "block_device",	sizeof(struct block_device) },
#endif
	{ "buffer_head",	sizeof(struct buffer_head) },
	{ "caddr_t",		sizeof(caddr_t) },
	{ "dentry",		sizeof(struct dentry) },
	{ "dev_t",		sizeof(dev_t) },
	{ "ext2_inode_info",	sizeof(struct ext2_inode_info) },
	{ "file",		sizeof(struct file) },
	{ "file_lock",		sizeof(struct file_lock) },
	{ "file_system_type",	sizeof(struct file_system_type) },
	{ "files_struct",	sizeof(struct files_struct) },
	{ "fs_struct",		sizeof(struct fs_struct) },
	{ "gid_t",		sizeof(gid_t) },
	{ "inode",		sizeof(struct inode) },
	{ "kdev_t",		sizeof(kdev_t) },
	{ "list_head",		sizeof(struct list_head) },
	{ "loff_t",		sizeof(loff_t) },
	{ "module",		sizeof(struct module) },
#if 0
	{ "nameidata",		sizeof(struct nameidata) },
#endif
	{ "nfs_fh",		sizeof(struct nfs_fh) },
	{ "nfs_inode_info",	sizeof(struct nfs_inode_info) },
	{ "nlink_t",		sizeof(nlink_t) },
	{ "page",		sizeof(struct page) },
#if 0
	{ "request_queue",	sizeof(struct request_queue) },
#endif
	{ "semaphore",		sizeof(struct semaphore) },
	{ "socket",		sizeof(struct socket) },
	{ "spinlock_t",		sizeof(spinlock_t) },
	{ "super_block",	sizeof(struct super_block) },
	{ "task_struct",	sizeof(struct task_struct) },
	{ "time_t",		sizeof(time_t) },
	{ "uid_t",		sizeof(uid_t) },
	{ "umode_t",		sizeof(umode_t) },
	{ "vfsmount",		sizeof(struct vfsmount) },
	{ "vm_area_struct",	sizeof(struct vm_area_struct) },
#if 0
	{ "wait_queue_head_t",	sizeof(wait_queue_head_t) },
#endif
};
int sizetbl_size = sizeof(sizetbl) / sizeof(sizetbl[0]);
