/*
 * Copyright (C) 2000-2002 ASANO Masahiro
 */

#include <unistd.h>
#include <linux/major.h>
#include "crash.h"

PRIVATE addr_t request_queue();
const commandtable_t command_request_queue =
	{"request_queue", request_queue, "address", "print request_queue table"};

PRIVATE addr_t blk_dev_addr;

extern addr_t print_request_queue();
extern addr_t print_request();

PRIVATE addr_t
request_queue()
{
	int c;
	int full = 0;

	while ((c = getopt(argcnt, args, "f")) != EOF) {
		switch (c) {
		case 'f':
			full = 1;	break;
		default:
			THROW(usage);
		}
	}
	if (argcnt == optind) {
		THROW(usage);
	}
	while (args[optind]) {
		(void) print_request_queue(getaddr(args[optind]), full);
		optind++;
	}
	return 0;
}

addr_t
request()
{
	int c, full = 0;

	while ((c = getopt(argcnt, args, "f")) != EOF) {
		switch (c) {
		case 'f':
			full = 1;	break;
		default:
			THROW(usage);
		}
	}
	if (argcnt == optind) {
		THROW(usage);
	}
	while (args[optind]) {
		(void) print_request(getaddr(args[optind]), full);
		optind++;
	}
	return 0;
}
