/*
 * Copyright (C) 2000-2002 ASANO Masahiro
 */

#include "def.h"

#define __KERNEL__
#include <linux/fs.h>
#include <linux/buffer_head.h>

void
prhead_buffer_head()
{
	mprintf(SPTR"    BLOCK SIZE CNT   DEV    RDEV   "SPTR" "SPTR" FLAG\n",
		"ADDR", "DATA", "PAGE");
}

addr_t
print_buffer_head(addr, full, lru)
	addr_t addr;
	int full;
	int lru;
{
	struct buffer_head buf;
	static const struct bitname bstate[] = {
		{ 1<<BH_Uptodate,	"uptodate" },
		{ 1<<BH_Dirty,		"dirty" },
		{ 1<<BH_Lock,		"lock" },
		{ 1<<BH_Req,		"req" },
		{ 1<<BH_Mapped,		"mapped" },
		{ 1<<BH_New,		"new" },
		{ 1<<BH_Async_Read,	"async_read" },
		{ 1<<BH_Async_Write,	"async_write" },
		{ 1<<BH_Boundary,	"Boundary" },
		{ 1<<BH_PrivateStart,	"privateStart" },
		{ 0,			NULL }
	};

	memread(addr, sizeof(struct buffer_head), &buf, "buffer_head");
	mprintf(FPTR " ", addr);

	mprintf("%8lx %5x %3x ", buf.b_blocknr, buf.b_size, ATOMIC_READ(buf.b_count));
	mprintf(FPTR, buf.b_bdev);
	mprintf(" " FPTR " " FPTR, buf.b_data, buf.b_page);
	mprintbit(bstate, buf.b_state);
	mprintf("\n");
	if (full) {
		mprintf("\t"SPTR" "SPTR" "SPTR"\n", "PAGE", "END_IO", "PRIVATE");
		mprintf("\t" FPTR " " FPTR " " FPTR " " FPTR "\n\n",
			buf.b_page, buf.b_end_io, buf.b_private);
	}
	return (addr_t)buf.b_this_page;
}
