/*
 * Copyright (C) 2000-2003 ASANO Masahiro
 */

#include "def.h"

#define __KERNEL__
#include <linux/spinlock.h>
#include <linux/slab.h>
#include <linux/init.h>
#include "slab.h"

addr_t print_slab();
addr_t print_kmem_cache();

void
prhead_slab()
{
	mprintf(SPTR" "SPTR" COL "SPTR" INU FREE\n",
		"ADDR", "NEXT", "S_MEM");
}

addr_t
print_slab(addr, num)
	addr_t addr;
	int num;
{
	struct slab slab;
	kmem_bufctl_t buf[512], ix = slab.free;

	memread(addr, sizeof(slab), &slab, "slab_t");
	mprintf(FPTR " ", addr);

	mprintf(FPTR " %3lx " FPTR " %3x", slab.list.next, slab.colouroff, slab.s_mem, slab.inuse);

	if (slab.free == BUFCTL_END) {
		ix = slab.inuse;
		mprintf(" -\n");
	} else {
		if (num == 0 || num > LENGTHOF(buf)) {
			num = LENGTHOF(buf);
		}
		ix = slab.free;
		memread(addr + sizeof(slab), sizeof(buf[0]) * num, buf, "slab_t");
		while (1) {
			if (ix >= num) {
				mprintf(" ?\n");
				return 0;
			}
			mprintf(" %x", ix);
			if (buf[ix] == BUFCTL_END)
				break;
			else if (buf[ix] == ix) {
				mprintf("...?\n");
				return 0;
			}
			ix = buf[ix];
		}
		mprintf("\n");
	}
	return (addr_t)slab.list.next - OFFSET(struct slab, list);
}

addr_t
print_kmem_list3(addr, num)
	addr_t addr;
	int num;
{
	struct kmem_list3 list3;

	memread(addr, sizeof(list3), &list3, "kmem_list3");
	mprintf(FPTR " ", addr);
	mprintf("slabs_full    " FPTR " " FPTR "\n",
		list3.slabs_full.next, list3.slabs_full.prev);
	mprintf("slabs_partial " FPTR " " FPTR "\n",
		list3.slabs_partial.next, list3.slabs_partial.prev);
	mprintf("slabs_free    " FPTR " " FPTR "\n",
		list3.slabs_free.next, list3.slabs_free.prev);
	mprintf("free_objects  %lx\n", list3.free_objects);
	mprintf("free_touched  %x\n",  list3.free_touched);
	mprintf("next_reap     %lx\n", list3.next_reap);

	if (num > 0) {
		addr_t sad;
		int none;
		mprintf("slabs_full:\n");
		prhead_slab();
		sad = (addr_t)list3.slabs_full.next - OFFSET(struct slab, list);
		none = 1;
		while (sad && sad != addr + OFFSET(struct kmem_list3, slabs_full)) {
			sad = print_slab(sad, num);
			none = 0;
		}
		if (none)
			mprintf(SPTR"\n", "(none)");

		mprintf("slabs_partial:\n");
		prhead_slab();
		sad = (addr_t)list3.slabs_partial.next - OFFSET(struct slab, list);
		none = 1;
		while (sad && sad != addr + OFFSET(struct kmem_list3, slabs_partial)) {
			sad = print_slab(sad, num);
			none = 0;
		}
		if (none)
			mprintf(SPTR"\n", "(none)");
	}
	return 0;
}

void
prhead_kmem_cache()
{
	mprintf(SPTR"  SIZE NUM  COL COFF NEXT  NAME\n", "ADDR");
}

addr_t
print_kmem_cache(addr, sflag, full, next)
	addr_t addr;
	int sflag;
	int full;
	int next;
{
	kmem_cache_t cache;
	char name[64];
	const char *p;

	if (next) {
		addr -= OFFSET(kmem_cache_t, next);
	}
	memread(addr, sizeof(cache), &cache, "kmem_cache_t");
	memread((addr_t)cache.name, sizeof(name), name, "kmem_cache_t");

	if (!full) {
		mprintf(FPTR " %5x %3x %4lx %4x %4x  ",
			addr, cache.objsize, cache.num, cache.colour,
			cache.colour_off, cache.colour_next);
		mprint_str(name, sizeof(name));
		mprintf("\n");

	} else {
		mprintf("addr: " FPTR "\n", addr);
		mprintf("objsize      %x\n", cache.objsize);
		mprintf("flags        %x\n", cache.flags);
		mprintf("num          %x\n", cache.num);
		mprintf("free_limit   %x\n", cache.free_limit);
		mprintf("gfporder     %x\n", cache.gfporder);
		mprintf("gfpflags     %x\n", cache.gfpflags);
		mprintf("colour       %lx\n", cache.colour);
		mprintf("colour_off   %x\n", cache.colour_off);
		mprintf("colour_next  %x\n", cache.colour_next);
		mprintf("slabp_cache   " FPTR "\n", cache.slabp_cache);
		mprintf("dflags       %x\n", cache.dflags);
		p = getsymstr((addr_t)cache.ctor);
		mprintf("ctor/dtor    %s", p? p: "NULL");
		p = getsymstr((addr_t)cache.dtor);
		mprintf("  %s\n", p? p: "NULL");
		mprintf("name         \"");
		mprint_str(name, sizeof(name));
		mprintf("\"\n");
		mprintf("next          " FPTR " " FPTR "\n",
			cache.next.next, cache.next.prev);
	}

	if (sflag) {
		print_kmem_list3(addr + OFFSET(kmem_cache_t, lists), cache.num);
	}
	if (next) {
		return (addr_t)cache.next.next;
	} else {
		return (addr_t)cache.next.next - OFFSET(kmem_cache_t, next);
	}
}

int
search_slab(addr)
	addr_t addr;
{
	extern addr_t cache_chain_addr;
	addr_t kmaddr, saddr;
	kmem_cache_t cache;
	struct slab slab;
	char name[64];
	int len, n;

	memread(cache_chain_addr, sizeof(kmaddr), &kmaddr, "cache_chain");
	while (kmaddr && kmaddr != cache_chain_addr) {
		memread(kmaddr - OFFSET(kmem_cache_t, next), sizeof(cache), &cache, "kmem_cache_t");
		len = cache.objsize * cache.num;

		saddr = (addr_t)cache.lists.slabs_full.next - OFFSET(struct slab, list);
		while (saddr && saddr != kmaddr - OFFSET(kmem_cache_t, next) + OFFSET(kmem_cache_t, lists.slabs_full)) {
			memread(saddr, sizeof(slab), &slab, "slab_t");
			if (addr >= (addr_t)slab.s_mem && addr < (addr_t)slab.s_mem + len)
				goto found;
			saddr = (addr_t)slab.list.next - OFFSET(struct slab, list);
		}
		saddr = (addr_t)cache.lists.slabs_partial.next - OFFSET(struct slab, list);
		while (saddr && saddr != kmaddr - OFFSET(kmem_cache_t, next) + OFFSET(kmem_cache_t, lists.slabs_partial)) {
			memread(saddr, sizeof(slab), &slab, "slab_t");
			if (addr >= (addr_t)slab.s_mem && addr < (addr_t)slab.s_mem + len)
				goto found;
			saddr = (addr_t)slab.list.next - OFFSET(struct slab, list);
		}
		kmaddr = (addr_t)cache.next.next;
	}

	return 0;	/* not found */
found:
	memread((addr_t)cache.name, sizeof(name), name, "kmem_cache_t");
	n = (addr - (addr_t)slab.s_mem) / cache.objsize;
	mprintf("slab \"%s\" offset %lx ", name,
		(addr - (addr_t)slab.s_mem) - n * cache.objsize);

	if (slab.free == BUFCTL_END) {
		mprintf("inuse\n");
	} else {
		int num = cache.num;
		kmem_bufctl_t buf[512], ix = slab.free;

		if (num > LENGTHOF(buf))
			num = LENGTHOF(buf);
		ix = slab.free;
		memread(saddr + sizeof(slab), sizeof(buf[0]) * num, buf, "slab_t");
		while (1) {
			if (ix == n) {
				mprintf("free\n");
				break;
			} else if (ix < 0 || ix >= num) {
				mprintf("unknown\n");
				break;
			} else if (buf[ix] == BUFCTL_END) {
				mprintf("inuse\n");
				break;
			}
			ix = buf[ix];
		}
	}
	return 1;
}
