/*
 * Copyright (C) 2000-2003 ASANO Masahiro
 */

#include <unistd.h>
#include "crash.h"

PRIVATE addr_t module();
const commandtable_t command_module =
	{"module", module, "[address]", "print module table"};

addr_t module_list_addr;
extern addr_t print_module();
extern addr_t getmsyms();

PRIVATE addr_t
module()
{
	int i, c;
	int full = 0;
	addr_t addr;
	extern void prhead_module();

	while ((c = getopt(argcnt, args, "f")) != EOF) {
		switch (c) {
		case 'f':
			full = 1;
			break;
		default:
			THROW(usage);
		}
	}

	if (argcnt > optind) {
		if (!full) prhead_module();
		for (i = optind; i < argcnt; i++) {
			addr = getaddr(args[i]);
			if (full) prhead_module();
			addr = print_module(addr, full);
		}
	} else {
#if LINUXVER>=25
		static addr_t modules_addr;
		GETADDR(modules);
		module_list_addr = modules_addr;
#else
		GETADDR(module_list);
#endif
		memread(module_list_addr, sizeof(addr), &addr, "module_list");
		if (!full) prhead_module();
		while (addr && addr != module_list_addr) {
			if (full) prhead_module();
			addr = print_module(addr, full);
		}
	}
	return addr;
}

/*
 *	call at initializing
 */
void
get_module_symbol(addr)
	addr_t addr;
{
	TRY {
		memread(addr, sizeof(addr), &addr, "module_list");
		while (addr && addr != module_list_addr) {
			addr = getmsyms(addr);
		}
	} CATCH {
		fprintf(stderr, "%s\n", except_message);
	}
	ENDTRY
}
