/*
 * Copyright (C) 2003 ASANO Masahiro
 */

#include <sys/stat.h>
#include <unistd.h>
#include "crash.h"
#include "flags_sched.h"

#ifdef _sighand_struct_has_action
PRIVATE addr_t sighand_struct();
const commandtable_t command_sighand_struct =
	{"sighand_struct", sighand_struct, "address", "print sighand_struct table"};
extern addr_t print_sighand_struct();
#else
PRIVATE addr_t signal_struct();
const commandtable_t command_signal_struct =
	{"signal_struct", signal_struct, "address", "print signal_struct table"};
extern addr_t print_signal_struct();
#endif


PRIVATE addr_t
#ifdef _sighand_struct_has_action
sighand_struct()
#else
signal_struct()
#endif
{
	addr_t addr = 0;
	int c;

	while ((c = getopt(argcnt, args, "")) != EOF) {
		switch (c) {
		default:
			THROW(usage);
		}
	}

	if (optind == argcnt) {
		THROW(usage);
	} else {
		while (args[optind]) {
#ifdef _sighand_struct_has_action
			addr = print_sighand_struct(getvalue(args[optind]));
#else
			addr = print_signal_struct(getvalue(args[optind]));
#endif
			optind++;
		}
	}
	return addr;
}
