/*
 * Copyright (C) 2000-2002 ASANO Masahiro
 */

#include <unistd.h>
#include "crash.h"

PRIVATE addr_t bh();
const commandtable_t command_bh =
	{"bh", bh, "", "print bh_base table"};

addr_t bh_base_addr;

PRIVATE const char *bhname[32] = {
	"TIMER_BH", "TQUEUE_BH", "DIGI_BH", "SERIAL_BH",
	"RISCOM8_BH", "SPECIALIX_BH", "AURORA_BH", "ESP_BH",
	"SCSI_BH", "IMMEDIATE_BH", "CYCLADES_BH",
	"CM206_BH", "JS_BH", "MACSERIAL_BH", "ISICOM_BH"
};

void
print_bh_base(addr, empty)
	addr_t addr;
	int empty;
{
	int i;
	addr_t buf[32];
	const char *p;

	memread(addr, sizeof(buf), buf, "bh_base");
	for (i = 0; i < 32; i++) {
		if (bhname[i] == NULL && buf[i] == 0 && empty == 0)
			continue;
		p = getsymstr(buf[i]);
		mprintf("%14s %4d  " FPTR "  %s\n", bhname[i]? bhname[i]: "-", i,  buf[i], p? p: "-");
	}
}

PRIVATE addr_t
bh()
{
	int c;
	int empty = 0;

	while ((c = getopt(argcnt, args, "e")) != EOF) {
		switch (c) {
		case 'e':
			empty = 1;
			break;
		default:
			THROW(usage);
		}
	}

	GETADDR(bh_base);

	print_bh_base(bh_base_addr, empty);
	return 0;
}
