/*
 * Copyright (C) 2000-2002 ASANO Masahiro
 */

#include "def.h"

#define __KERNEL__
#include <linux/fs.h>
#include <linux/mm.h>
#include <linux/sched.h>
#include <linux/module.h>
#include <linux/blkdev.h>
#include <linux/lvm.h>
#include <linux/slab.h>

#include "slab.h"

struct sizetbl sizetbl[] = {
	{ "char",		sizeof(char) },
	{ "short",		sizeof(short) },
	{ "int",		sizeof(int) },
	{ "long",		sizeof(long) },
	{ "*",			sizeof(void*) },

	{ "address_space",	sizeof(struct address_space) },
	{ "atomic_t",		sizeof(atomic_t) },
	{ "blk_dev_struct",	sizeof(struct blk_dev_struct) },
	{ "block_device",	sizeof(struct block_device) },
	{ "buffer_head",	sizeof(struct buffer_head) },
	{ "caddr_t",		sizeof(caddr_t) },
	{ "dentry",		sizeof(struct dentry) },
	{ "dev_t",		sizeof(dev_t) },
	{ "ext2_inode_info",	sizeof(struct ext2_inode_info) },
	{ "file",		sizeof(struct file) },
	{ "file_lock",		sizeof(struct file_lock) },
	{ "file_system_type",	sizeof(struct file_system_type) },
	{ "files_struct",	sizeof(struct files_struct) },
	{ "fs_struct",		sizeof(struct fs_struct) },
	{ "gid_t",		sizeof(gid_t) },
	{ "ino_t",		sizeof(ino_t) },
	{ "inode",		sizeof(struct inode) },
	{ "kdev_t",		sizeof(kdev_t) },
	{ "k_sigaction",	sizeof(struct k_sigaction) },
	{ "kmem_cache_t",	sizeof(kmem_cache_t) },
	{ "list_head",		sizeof(struct list_head) },
	{ "loff_t",		sizeof(loff_t) },
	{ "lv_disk_t",		sizeof(lv_disk_t) },
	{ "lv_t",		sizeof(lv_t) },
	{ "mem_map_t",		sizeof(mem_map_t) },
	{ "mm_struct",		sizeof(struct mm_struct) },
	{ "module",		sizeof(struct module) },
	{ "nameidata",		sizeof(struct nameidata) },
	{ "nfs_fh",		sizeof(struct nfs_fh) },
	{ "nfs_inode_info",	sizeof(struct nfs_inode_info) },
	{ "nlink_t",		sizeof(nlink_t) },
	{ "page",		sizeof(struct page) },
	{ "pglist_data",	sizeof(struct pglist_data) },
	{ "pv_disk_t",		sizeof(pv_disk_t) },
	{ "pv_t",		sizeof(pv_t) },
	{ "request",		sizeof(struct request) },
	{ "request_queue",	sizeof(struct request_queue) },
	{ "semaphore",		sizeof(struct semaphore) },
	{ "signal_struct",	sizeof(struct signal_struct) },
	{ "sigpending",		sizeof(struct sigpending) },
	{ "sigset_t",		sizeof(sigset_t) },
	{ "slab_t",		sizeof(slab_t) },
	{ "socket",		sizeof(struct socket) },
	{ "spinlock_t",		sizeof(spinlock_t) },
	{ "super_block",	sizeof(struct super_block) },
	{ "task_struct",	sizeof(struct task_struct) },
	{ "thread_struct",	sizeof(struct thread_struct) },
	{ "time_t",		sizeof(time_t) },
	{ "tq_struct",		sizeof(struct tq_struct) },
	{ "uid_t",		sizeof(uid_t) },
	{ "umode_t",		sizeof(umode_t) },
	{ "vfsmount",		sizeof(struct vfsmount) },
	{ "vg_disk_t",		sizeof(vg_disk_t) },
	{ "vg_t",		sizeof(vg_t) },
	{ "vm_area_struct",	sizeof(struct vm_area_struct) },
	{ "wait_queue_head_t",	sizeof(wait_queue_head_t) },
	{ "zone_t",		sizeof(zone_t) },
};
int sizetbl_size = sizeof(sizetbl) / sizeof(sizetbl[0]);
