/*
 * Copyright (C) 2000-2002 ASANO Masahiro
 */

#include "def.h"

#define __KERNEL__
#if defined(XFS_OLDDIR)
#define _PAGE_BUF_INTERNAL_
#include <linux/fs.h>
#include <linux/page_buf.h>
#else
#include <avl.h>
#include <page_buf.h>
#endif

extern void prhead_semaphore();
extern addr_t print_semaphore();

void
prhead_pagebuf()
{
	mprintf(SPTR" "SPTR" HD       BN   OFFSET LENG "SPTR" ERR CNT OFFS "SPTR" FLAGS\n",
		"ADDR", "TARGET", "ADDR", "PAGES");
}

addr_t
print_pagebuf(addr, fflag)
	addr_t addr;
	int fflag;
{
	page_buf_t pb;
	static const struct bitname pbflags[] = {
		{ PBF_READ,		"read" },
		{ PBF_WRITE,		"write" },
		{ PBF_MAPPED,		"mapped" },
		{ PBF_PARTIAL,		"partial" },
		{ PBF_ASYNC,		"async" },
		{ PBF_NONE,		"none" },
		{ PBF_DELWRI,		"delwri" },
		{ PBF_FREED,		"freed" },
		{ PBF_SYNC,		"sync" },
		{ PBF_MAPPABLE,		"mappable" },
		{ PBF_STALE,		"stale" },
#if 0
		{ PBF_FS_MANAGED,	"fs_managed" },
#endif
		{ PBF_RELEASE,		"release" },

		{ PBF_LOCK,		"lock" },
		{ PBF_TRYLOCK,		"trylock" },
		{ PBF_ALLOCATE,		"allocate" },
		{ PBF_FILE_ALLOCATE,	"file_allocate" },
		{ PBF_DONT_BLOCK,	"dont_block" },
		{ PBF_DIRECT,		"direct" },
		{ PBF_ENTER_PAGES,	"enter_pages" },

		{ _PBF_LOCKABLE,	"_lockable" },
		{ _PBF_ALL_PAGES_MAPPED,"_all_pages_mapped" },
		{ _PBF_SOME_INVALID_PAGES,"_some_invalid_pages" },
		{ _PBF_ADDR_ALLOCATED,	"_addr_allocated" },
		{ _PBF_MEM_ALLOCATED,	"_mem_allocated" },

#if 0
		{ PBF_GRIO,		"grio" },
#endif
		{ PBF_FORCEIO,		"forceio" },
		{ 0,			NULL }
	};

	memread(addr, sizeof(pb), &pb, "page_buf_t");
	mprintf(FPTR " ", addr);

	mprintf(FPTR, pb.pb_target);
	mprintf(" %2x", pb.pb_hold);
	mprintf(" %8lx", pb.pb_bn);
	mprintf(" %8lx", pb.pb_file_offset);
	mprintf(" %4lx", pb.pb_buffer_length);
	mprintf(" " FPTR, pb.pb_addr);
	mprintf(" %3x", pb.pb_error);
	mprintf(" %3x", pb.pb_page_count);
	mprintf(" %4x", pb.pb_offset);
	mprintf(" " FPTR, pb.pb_pages);
	mprintbit(pbflags, pb.pb_flags);
	mprintf("\n");

	if (fflag) {
		mprintf("  iodone: " FPTR "\n", pb.pb_iodone);
		mprintf("  relse:  " FPTR "\n", pb.pb_relse);
		mprintf("  strat:  " FPTR "\n", pb.pb_strat);
		mprintf("  iodonesema:\n");
#if 0
		/* new style */
		prhead_semaphore();
		print_semaphore(addr + OFFSET(page_buf_t, pb_iodonesema));
#else
		/* old fushion */
		prhead_semaphore();
		print_semaphore(addr + OFFSET(struct page_buf_private_s, pb_iodonesema));
		/*struct page_buf_private_s priv;*/
		/*memread(addr, sizeof(priv), &priv, "page_buf_private_t");*/
#endif
	}

	return (addr_t)pb.pb_list.next - OFFSET(page_buf_t, pb_list);
}
