/*
 * Copyright (C) 2000-2002 ASANO Masahiro
 */

#include <unistd.h>
#include <string.h>
#include "crash.h"

PRIVATE addr_t sizeof_cmd();
const commandtable_t command_sizeof =
	{"sizeof", sizeof_cmd, "[tables]", "print size of various tables"};

static const char head_sizeof[] = "           TYPE NAME    DEC   HEX\n";

PRIVATE void
prsize(n)
	int n;
{
	mprintf("%20s %6u %5x\n", sizetbl[n].name,
		sizetbl[n].size, sizetbl[n].size);
}

PRIVATE addr_t
sizeof_cmd()
{
	int c, i;

	while ((c = getopt(argcnt, args, "")) != EOF) {
		THROW(usage);
	}

	mprintf(head_sizeof);
	if (argcnt == optind) {
		for (i = 0; i < sizetbl_size; i++)
			prsize(i);
		mprintf(head_sizeof);
		return 0;
	}

	for (; args[optind]; optind++) {
		int found = 0;

		for (i = 0; i < sizetbl_size; i++) {
			if (strcmp(sizetbl[i].name, args[optind]) == 0) {
				prsize(i);
				found = 1;
				break;
			}
		}
		if (found) {
			prsize(i);
			continue;
		}
		for (i = 0; i < sizetbl_size; i++) {
			if (strstr(sizetbl[i].name, args[optind])) {
				prsize(i);
				found = 1;
			}
		}
		if (!found) {
			THROWF("unknown type name: %s", args[optind]);
		}
	}
	return 0;
}

int
sizeof_func(sym)
const char *sym;
{
	int i;

	for (i = 0; i < sizetbl_size; i++) {
		if (strcmp(sym, sizetbl[i].name) == 0)
			return sizetbl[i].size;
	}
	THROWF("unknown type name: %s", sym);
}
