/*
 * Copyright (C) 2000-2002 ASANO Masahiro
 */

#include <unistd.h>
#include "crash.h"

PRIVATE addr_t namespace();
const commandtable_t command_namespace =
	{"namespace", namespace, "address", "print namespace table"};

extern void prhead_namespace();
extern addr_t print_namespace();

PRIVATE addr_t
namespace()
{
	int c;

	while ((c = getopt(argcnt, args, "")) != EOF) {
		THROW(usage);
	}

	if (argcnt == optind) {
		THROW(usage);
	}
	while (args[optind]) {
		prhead_namespace();
		print_namespace(getaddr(args[optind]));
		optind++;
	}
	return 0;
}
